/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class DERWriter
extends FilterOutputStream {
    private final byte[] lenBytes = new byte[4];

    public DERWriter() {
        this(256);
    }

    public DERWriter(int initialSize) {
        this(new ByteArrayOutputStream(initialSize));
    }

    public DERWriter(OutputStream stream) {
        super(ValidateUtils.checkNotNull(stream, "No output stream"));
    }

    public void writeBigInteger(BigInteger value) throws IOException {
        this.writeBigInteger(ValidateUtils.checkNotNull(value, "No value").toByteArray());
    }

    public void writeBigInteger(byte ... bytes) throws IOException {
        this.writeBigInteger(bytes, 0, GenericUtils.length(bytes));
    }

    public void writeBigInteger(byte[] bytes, int off, int len) throws IOException {
        int padLen = len > 0 && (bytes[off] & 0x80) != 0 ? 1 : 0;
        this.write(2);
        this.writeLength(len + padLen);
        for (int index = 0; index < padLen; ++index) {
            this.write(0);
        }
        this.write(bytes, off, len);
    }

    public void writeObject(byte tag, int len, byte ... data) throws IOException {
        this.write(tag & 0xFF);
        this.writeLength(len);
        this.write(data, 0, len);
    }

    public void writeLength(int len) throws IOException {
        int nonZeroPos;
        ValidateUtils.checkTrue(len >= 0, "Invalid length: %d", (Object)len);
        if (len <= 127) {
            this.write(len);
            return;
        }
        BufferUtils.putUInt(len, this.lenBytes);
        for (nonZeroPos = 0; nonZeroPos < this.lenBytes.length && this.lenBytes[nonZeroPos] == 0; ++nonZeroPos) {
        }
        if (nonZeroPos >= this.lenBytes.length) {
            throw new StreamCorruptedException("All zeroes length representation for len=" + len);
        }
        int bytesLen = this.lenBytes.length - nonZeroPos;
        this.write(0x80 | bytesLen);
        this.write(this.lenBytes, nonZeroPos, bytesLen);
    }

    public byte[] toByteArray() throws IOException {
        if (this.out instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
        throw new IOException("The underlying stream is not a byte[] stream");
    }
}

