/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.Objects;
import java.util.logging.Level;
import org.apache.sshd.common.util.logging.AbstractSimplifiedLog;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public final class LoggingUtils {
    private LoggingUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean isLoggable(Level level, Level threshold) {
        if (level == null || threshold == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(threshold)) {
            return false;
        }
        if (Level.ALL.equals(threshold)) {
            return true;
        }
        return level.intValue() >= threshold.intValue();
    }

    public static SimplifiedLog wrap(final Logger logger) {
        if (logger == null) {
            return SimplifiedLog.EMPTY;
        }
        return new AbstractSimplifiedLog(){

            @Override
            public void log(Level level, Object message, Throwable t) {
                if (this.isEnabled(level)) {
                    LoggingUtils.logMessage(logger, level, message, t);
                }
            }

            @Override
            public boolean isEnabled(Level level) {
                return LoggingUtils.isLoggable(logger, level);
            }
        };
    }

    public static void logMessage(Logger logger, Level level, Object message, Throwable t) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return;
        }
        if (Level.SEVERE.equals(level)) {
            logger.error(Objects.toString(message), t);
        } else if (Level.WARNING.equals(level)) {
            logger.warn(Objects.toString(message), t);
        } else if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            logger.info(Objects.toString(message), t);
        } else if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            logger.debug(Objects.toString(message), t);
        } else {
            logger.trace(Objects.toString(message), t);
        }
    }

    public static boolean isLoggable(Logger logger, Level level) {
        if (logger == null || level == null || Level.OFF.equals(level)) {
            return false;
        }
        if (Level.SEVERE.equals(level)) {
            return logger.isErrorEnabled();
        }
        if (Level.WARNING.equals(level)) {
            return logger.isWarnEnabled();
        }
        if (Level.INFO.equals(level) || Level.ALL.equals(level)) {
            return logger.isInfoEnabled();
        }
        if (Level.CONFIG.equals(level) || Level.FINE.equals(level)) {
            return logger.isDebugEnabled();
        }
        return logger.isTraceEnabled();
    }
}

