/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class CachingPublicKeyAuthenticator
implements PublickeyAuthenticator,
SessionListener {
    protected final PublickeyAuthenticator authenticator;
    protected final Map<ServerSession, Map<PublicKey, Boolean>> cache = new ConcurrentHashMap<ServerSession, Map<PublicKey, Boolean>>();

    public CachingPublicKeyAuthenticator(PublickeyAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        Boolean result;
        Map<PublicKey, Boolean> map = this.cache.get(session);
        if (map == null) {
            map = new ConcurrentHashMap<PublicKey, Boolean>();
            this.cache.put(session, map);
            session.addListener(this);
        }
        if ((result = map.get(key)) == null) {
            result = this.authenticator.authenticate(username, key, session);
            map.put(key, result);
        }
        return result;
    }

    @Override
    public void sessionCreated(Session session) {
    }

    @Override
    public void sessionEvent(Session session, SessionListener.Event event) {
    }

    @Override
    public void sessionClosed(Session session) {
        this.cache.remove(session);
    }
}

