/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class AbstractServerChannel
extends AbstractChannel {
    protected boolean exitStatusSent;

    protected AbstractServerChannel() {
    }

    protected AbstractServerChannel(String discriminator) {
        super(discriminator);
    }

    @Override
    public OpenFuture open(int recipient, int rwSize, int packetSize, Buffer buffer) {
        this.recipient = recipient;
        this.remoteWindow.init(rwSize, packetSize, this.session.getFactoryManager().getProperties());
        this.configureWindow();
        return this.doInit(buffer);
    }

    @Override
    public void handleOpenSuccess(int recipient, int rwSize, int packetSize, Buffer buffer) throws IOException {
        throw new UnsupportedOperationException("handleOpenSuccess(" + recipient + "," + rwSize + "," + packetSize + ") N/A");
    }

    @Override
    public void handleOpenFailure(Buffer buffer) {
        throw new UnsupportedOperationException("handleOpenFailure() N/A");
    }

    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        f.setOpened();
        return f;
    }

    protected void sendExitStatus(int v) throws IOException {
        if (!this.exitStatusSent) {
            this.exitStatusSent = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send SSH_MSG_CHANNEL_REQUEST exit-status on channel {}", (Object)this.id);
            }
            Buffer buffer = this.session.createBuffer((byte)98);
            buffer.putInt(this.recipient);
            buffer.putString("exit-status");
            buffer.putBoolean(false);
            buffer.putInt(v);
            this.writePacket(buffer);
            this.notifyStateChanged();
        }
    }
}

