/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshdSocketAddress;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.channel.OpenChannelException;
import org.apache.sshd.server.forward.ForwardingFilter;

public class TcpipServerChannel
extends AbstractServerChannel {
    private final ForwardingFilter.Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private OutputStream out;

    public TcpipServerChannel(ForwardingFilter.Type type) {
        this.type = type;
    }

    public final ForwardingFilter.Type getChannelType() {
        return this.type;
    }

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        SshdSocketAddress address;
        final DefaultOpenFuture f = new DefaultOpenFuture(this);
        String hostToConnect = buffer.getString();
        int portToConnect = buffer.getInt();
        String originatorIpAddress = buffer.getString();
        int originatorPort = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{hostToConnect, portToConnect, originatorIpAddress, originatorPort});
        }
        switch (this.type) {
            case Direct: {
                address = new SshdSocketAddress(hostToConnect, portToConnect);
                break;
            }
            case Forwarded: {
                address = this.service.getTcpipForwarder().getForwardedPort(portToConnect);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown server channel type: " + this.type);
            }
        }
        Session session = this.getSession();
        FactoryManager manager = session.getFactoryManager();
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        if (address == null || filter == null || !filter.canConnect(this.type, address, session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doInit(" + session + ")[" + this.type + "][haveFilter=" + (filter != null) + "] filtered out " + address);
            }
            super.close(true);
            f.setException(new OpenChannelException(1, "Connection denied"));
            return f;
        }
        this.out = new ChannelOutputStream(this, this.remoteWindow, this.log, 94);
        IoHandler handler = new IoHandler(){

            @Override
            public void messageReceived(IoSession session, Readable message) throws Exception {
                if (TcpipServerChannel.this.isClosing()) {
                    if (TcpipServerChannel.this.log.isDebugEnabled()) {
                        TcpipServerChannel.this.log.debug("Ignoring write to channel {} in CLOSING state", (Object)TcpipServerChannel.this.id);
                    }
                } else {
                    ByteArrayBuffer buffer = new ByteArrayBuffer();
                    buffer.putBuffer(message);
                    TcpipServerChannel.this.out.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
                    TcpipServerChannel.this.out.flush();
                }
            }

            @Override
            public void sessionCreated(IoSession session) throws Exception {
            }

            @Override
            public void sessionClosed(IoSession session) throws Exception {
                TcpipServerChannel.this.close(false);
            }

            @Override
            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                TcpipServerChannel.this.close(true);
            }
        };
        this.connector = manager.getIoServiceFactory().createConnector(handler);
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress());
        future.addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isConnected()) {
                    TcpipServerChannel.this.ioSession = future.getSession();
                    f.setOpened();
                } else if (future.getException() != null) {
                    TcpipServerChannel.this.closeImmediately0();
                    if (future.getException() instanceof ConnectException) {
                        f.setException(new OpenChannelException(2, future.getException().getMessage(), future.getException()));
                    } else {
                        f.setException(future.getException());
                    }
                }
            }
        });
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
        ExecutorService service = this.getExecutorService();
        final ExecutorService executors = service == null ? ThreadUtils.newSingleThreadExecutor("TcpIpServerChannel-ConnectorCleanup[" + this.getSession() + "]") : service;
        final boolean shutdown = executors == service ? this.isShutdownOnExit() : true;
        executors.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpipServerChannel.this.connector.close(true);
                }
                finally {
                    if (executors != null && !executors.isShutdown() && shutdown) {
                        List<Runnable> runners = executors.shutdownNow();
                        if (TcpipServerChannel.this.log.isDebugEnabled()) {
                            TcpipServerChannel.this.log.debug("destroy() - shutdown executor service - runners count=" + runners.size());
                        }
                    }
                }
            }
        });
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture sshFuture) {
                TcpipServerChannel.this.closeImmediately0();
            }
        });
    }

    @Override
    protected void doWriteData(byte[] data, int off, final int len) throws IOException {
        ByteArrayBuffer buf = new ByteArrayBuffer(data, off, len);
        buf = new ByteArrayBuffer(buf.getCompactData());
        this.ioSession.write(buf).addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture future) {
                try {
                    TcpipServerChannel.this.localWindow.consumeAndCheck(len);
                }
                catch (IOException e) {
                    TcpipServerChannel.this.session.exceptionCaught(e);
                }
            }
        });
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException(this.type + "Tcpip channel does not support extended data");
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final ForwardingFilter.Type type;

        protected TcpipFactory(ForwardingFilter.Type type) {
            this.type = type;
        }

        public final ForwardingFilter.Type getType() {
            return this.type;
        }

        @Override
        public final String getName() {
            return this.type.getName();
        }

        @Override
        public ExecutorService getExecutorService() {
            return null;
        }

        @Override
        public boolean isShutdownOnExit() {
            return false;
        }

        @Override
        public Channel create() {
            TcpipServerChannel channel = new TcpipServerChannel(this.getType());
            channel.setExecutorService(this.getExecutorService());
            channel.setShutdownOnExit(this.isShutdownOnExit());
            return channel;
        }
    }
}

