/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import java.io.IOException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.AbstractConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.session.ServerSession;

public class ServerConnectionService
extends AbstractConnectionService {
    protected ServerConnectionService(Session s) throws SshException {
        super(s);
        ValidateUtils.checkTrue(s instanceof ServerSession, "Server side service used on client side");
        if (!this.session.isAuthenticated()) {
            throw new SshException("Session is not authenticated");
        }
    }

    @Override
    public String initAgentForward() throws IOException {
        return this.agentForward.initialize();
    }

    @Override
    public String createX11Display(boolean singleConnection, String authenticationProtocol, String authenticationCookie, int screen) throws IOException {
        return this.x11Forward.createDisplay(singleConnection, authenticationProtocol, authenticationCookie, screen);
    }
}

