/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.shell.InvertedShell;

public class InvertedShellWrapper
implements Command,
SessionAware {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final InvertedShell shell;
    private final Executor executor;
    private final int bufferSize;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private OutputStream shellIn;
    private InputStream shellOut;
    private InputStream shellErr;
    private ExitCallback callback;
    private boolean shutdownExecutor;

    public InvertedShellWrapper(InvertedShell shell) {
        this(shell, 8192);
    }

    public InvertedShellWrapper(InvertedShell shell, Executor executor) {
        this(shell, executor, 8192);
    }

    public InvertedShellWrapper(InvertedShell shell, int bufferSize) {
        this(shell, ThreadUtils.newSingleThreadExecutor("shell[" + Integer.toHexString(shell.hashCode()) + "]"), true, bufferSize);
    }

    public InvertedShellWrapper(InvertedShell shell, Executor executor, int bufferSize) {
        this(shell, executor, false, bufferSize);
    }

    public InvertedShellWrapper(InvertedShell shell, Executor executor, boolean shutdownExecutor, int bufferSize) {
        this.shell = shell;
        this.executor = executor;
        this.bufferSize = bufferSize;
        this.shutdownExecutor = shutdownExecutor;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setSession(ServerSession session) {
        if (this.shell instanceof SessionAware) {
            ((SessionAware)((Object)this.shell)).setSession(session);
        }
    }

    @Override
    public synchronized void start(Environment env) throws IOException {
        this.shell.start(env.getEnv());
        this.shellIn = this.shell.getInputStream();
        this.shellOut = this.shell.getOutputStream();
        this.shellErr = this.shell.getErrorStream();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                InvertedShellWrapper.this.pumpStreams();
            }
        });
    }

    @Override
    public synchronized void destroy() {
        this.shell.destroy();
        if (this.shutdownExecutor && this.executor instanceof ExecutorService) {
            ((ExecutorService)this.executor).shutdown();
        }
    }

    protected void pumpStreams() {
        try {
            byte[] buffer = new byte[this.bufferSize];
            while (true) {
                if (this.pumpStream(this.in, this.shellIn, buffer) || this.pumpStream(this.shellOut, this.out, buffer) || this.pumpStream(this.shellErr, this.err, buffer)) {
                    continue;
                }
                if (!this.shell.isAlive()) {
                    this.callback.onExit(this.shell.exitValue());
                    return;
                }
                Thread.sleep(1L);
            }
        }
        catch (Exception e) {
            this.shell.destroy();
            this.callback.onExit(this.shell.exitValue());
            return;
        }
    }

    private boolean pumpStream(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int available = in.available();
        if (available > 0) {
            int len = in.read(buffer);
            if (len > 0) {
                out.write(buffer, 0, len);
                out.flush();
                return true;
            }
        } else if (available == -1) {
            out.close();
        }
        return false;
    }
}

