/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sshd.server.subsystem.sftp.Handle;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;

public class FileHandle
extends Handle {
    private final int access;
    private final FileChannel fileChannel;
    private long pos;
    private final List<FileLock> locks = new ArrayList<FileLock>();

    public FileHandle(SftpSubsystem sftpSubsystem, Path file, int flags, int access, Map<String, Object> attrs) throws IOException {
        super(file);
        FileChannel channel;
        this.access = access;
        HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
        if ((access & 1) != 0 || (access & 0x80) != 0) {
            options.add(StandardOpenOption.READ);
        }
        if ((access & 2) != 0 || (access & 0x100) != 0) {
            options.add(StandardOpenOption.WRITE);
        }
        switch (flags & 7) {
            case 0: {
                options.add(StandardOpenOption.CREATE_NEW);
                break;
            }
            case 1: {
                options.add(StandardOpenOption.CREATE);
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                options.add(StandardOpenOption.CREATE);
                break;
            }
            case 4: {
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
                break;
            }
        }
        if ((flags & 8) != 0) {
            options.add(StandardOpenOption.APPEND);
        }
        FileAttribute[] attributes = new FileAttribute[attrs.size()];
        int index = 0;
        for (Map.Entry<String, Object> attr : attrs.entrySet()) {
            final String key = attr.getKey();
            final Object val = attr.getValue();
            attributes[index++] = new FileAttribute<Object>(){

                @Override
                public String name() {
                    return key;
                }

                @Override
                public Object value() {
                    return val;
                }
            };
        }
        try {
            channel = FileChannel.open(file, options, attributes);
        }
        catch (UnsupportedOperationException e) {
            channel = FileChannel.open(file, options, new FileAttribute[0]);
            sftpSubsystem.setAttributes(file, attrs);
        }
        this.fileChannel = channel;
        this.pos = 0L;
    }

    public final FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public int getAccessMask() {
        return this.access;
    }

    public boolean isOpenAppend() {
        return 4 == (this.getAccessMask() & 4);
    }

    public int read(byte[] data, long offset) throws IOException {
        return this.read(data, 0, data.length, offset);
    }

    public int read(byte[] data, int doff, int length, long offset) throws IOException {
        FileChannel channel = this.getFileChannel();
        if (this.pos != offset) {
            channel.position(offset);
            this.pos = offset;
        }
        int read = channel.read(ByteBuffer.wrap(data, doff, length));
        this.pos += (long)read;
        return read;
    }

    public void append(byte[] data) throws IOException {
        this.append(data, 0, data.length);
    }

    public void append(byte[] data, int doff, int length) throws IOException {
        FileChannel channel = this.getFileChannel();
        this.write(data, doff, length, channel.size());
    }

    public void write(byte[] data, long offset) throws IOException {
        this.write(data, 0, data.length, offset);
    }

    public void write(byte[] data, int doff, int length, long offset) throws IOException {
        FileChannel channel = this.getFileChannel();
        if (this.pos != offset) {
            channel.position(offset);
            this.pos = offset;
        }
        channel.write(ByteBuffer.wrap(data, doff, length));
        this.pos += (long)length;
    }

    @Override
    public void close() throws IOException {
        FileChannel channel = this.getFileChannel();
        channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(long offset, long length, int mask) throws IOException {
        FileChannel channel = this.getFileChannel();
        long size = length == 0L ? channel.size() - offset : length;
        FileLock lock = channel.tryLock(offset, size, false);
        List<FileLock> list = this.locks;
        synchronized (list) {
            this.locks.add(lock);
        }
    }

    public boolean unlock(long offset, long length) throws IOException {
        FileChannel channel = this.getFileChannel();
        long size = length == 0L ? channel.size() - offset : length;
        FileLock lock = null;
        Iterator<FileLock> iterator = this.locks.iterator();
        while (iterator.hasNext()) {
            FileLock l = iterator.next();
            if (l.position() != offset || l.size() != size) continue;
            iterator.remove();
            lock = l;
            break;
        }
        if (lock != null) {
            lock.release();
            return true;
        }
        return false;
    }
}

