/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.util.concurrent.ExecutorService;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystem;
import org.apache.sshd.server.subsystem.sftp.UnsupportedAttributePolicy;

public class SftpSubsystemFactory
implements SubsystemFactory,
Cloneable,
ExecutorServiceConfigurer {
    public static final String NAME = "sftp";
    public static final UnsupportedAttributePolicy DEFAULT_POLICY = UnsupportedAttributePolicy.Warn;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private UnsupportedAttributePolicy policy = DEFAULT_POLICY;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executors;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executors = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdownOnExit) {
        this.shutdownExecutor = shutdownOnExit;
    }

    public UnsupportedAttributePolicy getUnsupportedAttributePolicy() {
        return this.policy;
    }

    public void setUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
        if (p == null) {
            throw new IllegalArgumentException("No policy provided");
        }
        this.policy = p;
    }

    @Override
    public Command create() {
        return new SftpSubsystem(this.getExecutorService(), this.isShutdownOnExit(), this.getUnsupportedAttributePolicy());
    }

    public SftpSubsystemFactory clone() {
        try {
            return (SftpSubsystemFactory)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone exception", e);
        }
    }

    public static class Builder
    implements ObjectBuilder<SftpSubsystemFactory> {
        private final SftpSubsystemFactory factory = new SftpSubsystemFactory();

        public Builder withExecutorService(ExecutorService service) {
            this.factory.setExecutorService(service);
            return this;
        }

        public Builder withShutdownOnExit(boolean shutdown) {
            this.factory.setShutdownOnExit(shutdown);
            return this;
        }

        public Builder withUnsupportedAttributePolicy(UnsupportedAttributePolicy p) {
            this.factory.setUnsupportedAttributePolicy(p);
            return this;
        }

        @Override
        public SftpSubsystemFactory build() {
            return this.factory.clone();
        }
    }
}

