/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.api.repository.AppDefinitionQuery;
import org.flowable.app.api.repository.AppDeployment;
import org.flowable.app.api.repository.AppDeploymentQuery;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntity;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntityManager;
import org.flowable.app.engine.impl.persistence.entity.data.AppDeploymentDataManager;
import org.flowable.app.engine.impl.repository.AppDeploymentQueryImpl;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class AppDeploymentEntityManagerImpl
extends AbstractEngineEntityManager<AppEngineConfiguration, AppDeploymentEntity, AppDeploymentDataManager>
implements AppDeploymentEntityManager {
    public AppDeploymentEntityManagerImpl(AppEngineConfiguration appEngineConfiguration, AppDeploymentDataManager deploymentDataManager) {
        super((AbstractEngineConfiguration)appEngineConfiguration, (DataManager)deploymentDataManager);
    }

    public void insert(AppDeploymentEntity deployment) {
        super.insert((Entity)deployment, true);
        for (EngineResource resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getAppResourceEntityManager().insert((AppResourceEntity)resource);
        }
    }

    @Override
    public void deleteDeploymentAndRelatedData(String deploymentId, boolean cascade) {
        AppDefinitionEntityManager appDefinitionEntityManager = this.getAppDefinitionEntityManager();
        List appDefinitions = ((AppDefinitionQuery)appDefinitionEntityManager.createAppDefinitionQuery().deploymentId(deploymentId)).list();
        for (AppDefinition appDefinition : appDefinitions) {
            if (cascade) {
                appDefinitionEntityManager.deleteAppDefinitionAndRelatedData(appDefinition.getId());
                continue;
            }
            appDefinitionEntityManager.delete(appDefinition.getId());
        }
        this.getAppResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    @Override
    public AppDeploymentEntity findLatestDeploymentByName(String deploymentName) {
        return ((AppDeploymentDataManager)this.dataManager).findLatestDeploymentByName(deploymentName);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return ((AppDeploymentDataManager)this.dataManager).getDeploymentResourceNames(deploymentId);
    }

    @Override
    public AppDeploymentQuery createDeploymentQuery() {
        return new AppDeploymentQueryImpl(((AppEngineConfiguration)this.engineConfiguration).getCommandExecutor());
    }

    @Override
    public List<AppDeployment> findDeploymentsByQueryCriteria(AppDeploymentQuery deploymentQuery) {
        return ((AppDeploymentDataManager)this.dataManager).findDeploymentsByQueryCriteria((AppDeploymentQueryImpl)deploymentQuery);
    }

    @Override
    public long findDeploymentCountByQueryCriteria(AppDeploymentQuery deploymentQuery) {
        return ((AppDeploymentDataManager)this.dataManager).findDeploymentCountByQueryCriteria((AppDeploymentQueryImpl)deploymentQuery);
    }

    protected AppResourceEntityManager getAppResourceEntityManager() {
        return ((AppEngineConfiguration)this.engineConfiguration).getAppResourceEntityManager();
    }

    protected AppDefinitionEntityManager getAppDefinitionEntityManager() {
        return ((AppEngineConfiguration)this.engineConfiguration).getAppDefinitionEntityManager();
    }
}

