/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.app.engine.AppEngine;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringAppConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringAppConfigurationHelper.class);

    public static AppEngine buildAppEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND APP ENGINE =========================================");
        try (GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});){
            Map beansOfType = applicationContext.getBeansOfType(AppEngine.class);
            if (beansOfType == null || beansOfType.isEmpty()) {
                throw new FlowableException("no " + AppEngine.class.getName() + " defined in the application context " + resource);
            }
            AppEngine appEngine = (AppEngine)beansOfType.values().iterator().next();
            LOGGER.debug("==== SPRING APP ENGINE CREATED ==================================================================");
            AppEngine appEngine2 = appEngine;
            return appEngine2;
        }
    }
}

