/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangeCaseInstanceStateOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractDeleteCaseInstanceOperation
extends AbstractChangeCaseInstanceStateOperation {
    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, String caseInstanceId) {
        super(commandContext, caseInstanceId);
    }

    public AbstractDeleteCaseInstanceOperation(CommandContext commandContext, CaseInstanceEntity caseInstanceEntity) {
        super(commandContext, caseInstanceEntity);
    }

    @Override
    public void internalExecute() {
        this.deleteCaseInstance();
    }

    protected void deleteCaseInstance() {
        this.updateChildPlanItemInstancesState();
        String newState = this.getNewState();
        CallbackData callBackData = new CallbackData(this.caseInstanceEntity.getCallbackId(), this.caseInstanceEntity.getCallbackType(), this.caseInstanceEntity.getId(), this.caseInstanceEntity.getState(), newState);
        this.addAdditionalCallbackData(callBackData);
        CommandContextUtil.getCaseInstanceHelper(this.commandContext).callCaseInstanceStateChangeCallbacks(callBackData);
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(this.commandContext);
        CommandContextUtil.getCmmnHistoryManager(this.commandContext).recordCaseInstanceEnd(this.caseInstanceEntity, newState, cmmnEngineConfiguration.getClock().getCurrentTime());
        if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
            String loggingType = null;
            loggingType = "terminated".equals(this.getNewState()) ? "caseTerminated" : "caseCompleted";
            CmmnLoggingSessionUtil.addLoggingData(loggingType, "Completed case instance with id " + this.caseInstanceEntity.getId(), this.caseInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
        }
        CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).delete(this.caseInstanceEntity.getId(), false, this.getDeleteReason());
    }

    protected void updateChildPlanItemInstancesState() {
        List childPlanItemInstances = this.caseInstanceEntity.getChildPlanItemInstances();
        if (childPlanItemInstances != null) {
            for (PlanItemInstanceEntity childPlanItemInstance : childPlanItemInstances) {
                if (PlanItemInstanceState.isInTerminalState((PlanItemInstance)childPlanItemInstance)) continue;
                this.changeStateForChildPlanItemInstance(childPlanItemInstance);
            }
        }
    }

    public abstract String getDeleteReason();

    public void addAdditionalCallbackData(CallbackData callbackData) {
    }
}

