/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl.http;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.api.delegate.PlanItemFutureJavaDelegate;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.HttpClientConfig;
import org.flowable.cmmn.engine.impl.behavior.impl.http.handler.ClassDelegateHttpHandler;
import org.flowable.cmmn.engine.impl.behavior.impl.http.handler.DelegateExpressionHttpHandler;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.FlowableHttpRequestHandler;
import org.flowable.cmmn.model.FlowableHttpResponseHandler;
import org.flowable.cmmn.model.HttpServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.async.AsyncTaskInvoker;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.http.common.api.HttpRequest;
import org.flowable.http.common.api.HttpResponse;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.api.delegate.HttpRequestHandler;
import org.flowable.http.common.api.delegate.HttpResponseHandler;
import org.flowable.http.common.impl.BaseHttpActivityDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCmmnHttpActivityDelegate
extends BaseHttpActivityDelegate
implements PlanItemFutureJavaDelegate<BaseHttpActivityDelegate.ExecutionData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCmmnHttpActivityDelegate.class);

    public DefaultCmmnHttpActivityDelegate() {
        this(null);
    }

    public DefaultCmmnHttpActivityDelegate(FlowableHttpClient httpClient) {
        super(httpClient);
    }

    protected FlowableHttpClient createHttpClient() {
        HttpClientConfig config = CommandContextUtil.getCmmnEngineConfiguration().getHttpClientConfig();
        return config.determineHttpClient();
    }

    public CompletableFuture<BaseHttpActivityDelegate.ExecutionData> execute(DelegatePlanItemInstance planItemInstance, AsyncTaskInvoker taskInvoker) {
        HttpRequest request;
        HttpServiceTask httpServiceTask = (HttpServiceTask)planItemInstance.getPlanItemDefinition();
        try {
            request = this.createRequest((VariableContainer)planItemInstance, httpServiceTask.getId());
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            throw new FlowableException("request fields are invalid in execution " + planItemInstance.getId(), (Throwable)e);
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        HttpRequestHandler httpRequestHandler = this.createHttpRequestHandler(httpServiceTask.getHttpRequestHandler(), cmmnEngineConfiguration);
        if (httpRequestHandler != null) {
            httpRequestHandler.handleHttpRequest((VariableContainer)planItemInstance, request, null);
        }
        this.validateRequest(request);
        boolean parallelInSameTransaction = httpServiceTask.getParallelInSameTransaction() != null ? httpServiceTask.getParallelInSameTransaction().booleanValue() : cmmnEngineConfiguration.getHttpClientConfig().isDefaultParallelInSameTransaction();
        return this.prepareAndExecuteRequest(request, parallelInSameTransaction, taskInvoker);
    }

    public void afterExecution(DelegatePlanItemInstance planItemInstance, BaseHttpActivityDelegate.ExecutionData result) {
        HttpRequest request = result.getRequest();
        HttpResponse response = result.getResponse();
        Throwable resultException = result.getException();
        if (resultException != null) {
            if (request.isIgnoreErrors()) {
                LOGGER.info("Error ignored while processing http task in planItemInstance {}", (Object)planItemInstance.getId(), (Object)resultException);
                planItemInstance.setVariable(request.getPrefix() + "ErrorMessage", (Object)resultException.getMessage());
                return;
            }
            ExceptionUtil.sneakyThrow((Throwable)resultException);
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration();
        HttpServiceTask httpServiceTask = (HttpServiceTask)planItemInstance.getPlanItemDefinition();
        try {
            HttpResponseHandler httpResponseHandler = this.createHttpResponseHandler(httpServiceTask.getHttpResponseHandler(), cmmnEngineConfiguration);
            if (httpResponseHandler != null) {
                httpResponseHandler.handleHttpResponse((VariableContainer)planItemInstance, response);
            }
            this.saveResponseFields((VariableContainer)planItemInstance, request, response, cmmnEngineConfiguration.getObjectMapper());
        }
        catch (Exception ex) {
            if (request.isIgnoreErrors()) {
                LOGGER.info("Error ignored while processing http task in planItemInstance {}", (Object)planItemInstance.getId(), (Object)ex);
                planItemInstance.setVariable(request.getPrefix() + "ErrorMessage", (Object)ex.getMessage());
            }
            ExceptionUtil.sneakyThrow((Throwable)ex);
        }
    }

    protected HttpRequestHandler createHttpRequestHandler(FlowableHttpRequestHandler handler, CmmnEngineConfiguration cmmnEngineConfiguration) {
        HttpRequestHandler requestHandler = null;
        if (handler != null) {
            if ("class".equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new ClassDelegateHttpHandler(handler.getImplementation(), (List<FieldExtension>)handler.getFieldExtensions());
            } else if ("delegateExpression".equalsIgnoreCase(handler.getImplementationType())) {
                requestHandler = new DelegateExpressionHttpHandler(cmmnEngineConfiguration.getExpressionManager().createExpression(handler.getImplementation()), handler.getFieldExtensions());
            }
        }
        return requestHandler;
    }

    protected HttpResponseHandler createHttpResponseHandler(FlowableHttpResponseHandler handler, CmmnEngineConfiguration cmmnEngineConfiguration) {
        HttpRequestHandler responseHandler = null;
        if (handler != null) {
            if ("class".equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new ClassDelegateHttpHandler(handler.getImplementation(), (List<FieldExtension>)handler.getFieldExtensions());
            } else if ("delegateExpression".equalsIgnoreCase(handler.getImplementationType())) {
                responseHandler = new DelegateExpressionHttpHandler(cmmnEngineConfiguration.getExpressionManager().createExpression(handler.getImplementation()), handler.getFieldExtensions());
            }
        }
        return responseHandler;
    }

    protected void propagateError(VariableContainer container, String code) {
    }
}

