/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class GetTasksLocalVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> taskIds;

    public GetTasksLocalVariablesCmd(Set<String> taskIds) {
        this.taskIds = taskIds;
    }

    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.taskIds == null) {
            throw new FlowableIllegalArgumentException("taskIds is null");
        }
        if (this.taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of taskIds is empty");
        }
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        List entities = cmmnEngineConfiguration.getVariableServiceConfiguration().getVariableService().createInternalVariableInstanceQuery().taskIds(this.taskIds).list();
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>(entities.size());
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add((VariableInstance)entity);
        }
        return instances;
    }
}

