/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.AbstractDynamicInjectionCmd;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public class InjectUserTaskInProcessInstanceCmd
extends AbstractDynamicInjectionCmd
implements Command<Void> {
    protected String processInstanceId;
    protected DynamicUserTaskBuilder dynamicUserTaskBuilder;

    public InjectUserTaskInProcessInstanceCmd(String processInstanceId, DynamicUserTaskBuilder dynamicUserTaskBuilder) {
        this.processInstanceId = processInstanceId;
        this.dynamicUserTaskBuilder = dynamicUserTaskBuilder;
    }

    public Void execute(CommandContext commandContext) {
        this.createDerivedProcessDefinitionForProcessInstance(commandContext, this.processInstanceId);
        return null;
    }

    @Override
    protected void updateBpmnProcess(CommandContext commandContext, Process process, BpmnModel bpmnModel, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity) {
        List startEvents = process.findFlowElementsOfType(StartEvent.class);
        StartEvent initialStartEvent = null;
        for (StartEvent startEvent : startEvents) {
            if (startEvent.getEventDefinitions().size() == 0) {
                initialStartEvent = startEvent;
                break;
            }
            if (initialStartEvent != null) continue;
            initialStartEvent = startEvent;
        }
        ParallelGateway parallelGateway = new ParallelGateway();
        parallelGateway.setId(this.dynamicUserTaskBuilder.nextForkGatewayId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)parallelGateway);
        UserTask userTask = new UserTask();
        if (this.dynamicUserTaskBuilder.getId() != null) {
            userTask.setId(this.dynamicUserTaskBuilder.getId());
        } else {
            userTask.setId(this.dynamicUserTaskBuilder.nextTaskId(process.getFlowElementMap()));
        }
        this.dynamicUserTaskBuilder.setDynamicTaskId(userTask.getId());
        userTask.setName(this.dynamicUserTaskBuilder.getName());
        userTask.setAssignee(this.dynamicUserTaskBuilder.getAssignee());
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId(this.dynamicUserTaskBuilder.nextEndEventId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)endEvent);
        SequenceFlow flowToUserTask = new SequenceFlow(parallelGateway.getId(), userTask.getId());
        flowToUserTask.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowToUserTask);
        SequenceFlow flowFromUserTask = new SequenceFlow(userTask.getId(), endEvent.getId());
        flowFromUserTask.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowFromUserTask);
        SequenceFlow initialFlow = (SequenceFlow)initialStartEvent.getOutgoingFlows().get(0);
        initialFlow.setSourceRef(parallelGateway.getId());
        SequenceFlow flowFromStart = new SequenceFlow(initialStartEvent.getId(), parallelGateway.getId());
        flowFromStart.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        process.addFlowElement((FlowElement)flowFromStart);
        GraphicInfo elementGraphicInfo = bpmnModel.getGraphicInfo(initialStartEvent.getId());
        if (elementGraphicInfo != null) {
            double yDiff = 0.0;
            double xDiff = 80.0;
            if (elementGraphicInfo.getY() < 173.0) {
                yDiff = 173.0 - elementGraphicInfo.getY();
                elementGraphicInfo.setY(173.0);
            }
            Map locationMap = bpmnModel.getLocationMap();
            for (Object locationId : locationMap.keySet()) {
                if (initialStartEvent.getId().equals(locationId)) continue;
                GraphicInfo locationGraphicInfo = (GraphicInfo)locationMap.get(locationId);
                locationGraphicInfo.setX(locationGraphicInfo.getX() + xDiff);
                locationGraphicInfo.setY(locationGraphicInfo.getY() + yDiff);
            }
            Map flowLocationMap = bpmnModel.getFlowLocationMap();
            for (String flowId : flowLocationMap.keySet()) {
                if (flowFromStart.getId().equals(flowId)) continue;
                List flowGraphicInfoList = (List)flowLocationMap.get(flowId);
                for (GraphicInfo flowGraphicInfo : flowGraphicInfoList) {
                    flowGraphicInfo.setX(flowGraphicInfo.getX() + xDiff);
                    flowGraphicInfo.setY(flowGraphicInfo.getY() + yDiff);
                }
            }
            GraphicInfo forkGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 75.0, elementGraphicInfo.getY() - 5.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(parallelGateway.getId(), forkGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowFromStart.getId(), this.createWayPoints(elementGraphicInfo.getX() + 30.0, elementGraphicInfo.getY() + 15.0, elementGraphicInfo.getX() + 75.0, elementGraphicInfo.getY() + 15.0));
            GraphicInfo newTaskGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 185.0, elementGraphicInfo.getY() - 163.0, 80.0, 100.0);
            bpmnModel.addGraphicInfo(userTask.getId(), newTaskGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowToUserTask.getId(), this.createWayPoints(elementGraphicInfo.getX() + 95.0, elementGraphicInfo.getY() - 5.0, elementGraphicInfo.getX() + 95.0, elementGraphicInfo.getY() - 123.0, elementGraphicInfo.getX() + 185.0, elementGraphicInfo.getY() - 123.0));
            GraphicInfo endGraphicInfo = new GraphicInfo(elementGraphicInfo.getX() + 335.0, elementGraphicInfo.getY() - 137.0, 28.0, 28.0);
            bpmnModel.addGraphicInfo(endEvent.getId(), endGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(flowFromUserTask.getId(), this.createWayPoints(elementGraphicInfo.getX() + 285.0, elementGraphicInfo.getY() - 123.0, elementGraphicInfo.getX() + 335.0, elementGraphicInfo.getY() - 123.0));
        }
        BaseDynamicSubProcessInjectUtil.processFlowElements(commandContext, (FlowElementsContainer)process, bpmnModel, originalProcessDefinitionEntity, newDeploymentEntity);
    }

    @Override
    protected void updateExecutions(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance, List<ExecutionEntity> childExecutions) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity execution = executionEntityManager.createChildExecution(processInstance);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionEntity.getId());
        UserTask userTask = (UserTask)bpmnModel.getProcessById(processDefinitionEntity.getKey()).getFlowElement(this.dynamicUserTaskBuilder.getDynamicTaskId());
        execution.setCurrentFlowElement((FlowElement)userTask);
        Context.getAgenda().planContinueProcessOperation(execution);
    }
}

