/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ExecutionGraphUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class ParallelMultiInstanceWithNoWaitStatesAsyncLeaveJobHandler
implements JobHandler {
    public static final String TYPE = "parallel-multi-instance-no-waits-async-leave";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        Object behavior;
        FlowElement currentFlowElement;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(job.getExecutionId());
        if (execution != null && (currentFlowElement = execution.getCurrentFlowElement()) instanceof Activity && (behavior = ((Activity)currentFlowElement).getBehavior()) instanceof ParallelMultiInstanceBehavior) {
            ParallelMultiInstanceBehavior parallelMultiInstanceBehavior = (ParallelMultiInstanceBehavior)behavior;
            DelegateExecution multiInstanceRootExecution = ExecutionGraphUtil.getMultiInstanceRootExecution(execution);
            if (multiInstanceRootExecution != null) {
                long activeChildExecutionCount = executionEntityManager.countActiveExecutionsByParentId(multiInstanceRootExecution.getId());
                if (activeChildExecutionCount > 0L) {
                    List<String> boundaryEventActivityIds = ExecutionGraphUtil.getBoundaryEventActivityIds(multiInstanceRootExecution);
                    if (boundaryEventActivityIds.isEmpty()) {
                        this.reCreateJob(processEngineConfiguration, execution);
                    } else {
                        List<ExecutionEntity> boundaryEventChildExecutions = executionEntityManager.findExecutionsByParentExecutionAndActivityIds(multiInstanceRootExecution.getId(), boundaryEventActivityIds);
                        if (activeChildExecutionCount <= (long)boundaryEventChildExecutions.size()) {
                            this.leaveMultiInstance(processEngineConfiguration, execution, parallelMultiInstanceBehavior);
                        } else {
                            this.reCreateJob(processEngineConfiguration, execution);
                        }
                    }
                } else {
                    this.leaveMultiInstance(processEngineConfiguration, execution, parallelMultiInstanceBehavior);
                }
            }
        }
    }

    protected void reCreateJob(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionEntity execution) {
        JobService jobService = processEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity newJob = JobUtil.createJob(execution, TYPE, processEngineConfiguration);
        jobService.createAsyncJobNoTriggerAsyncExecutor(newJob, true);
        jobService.insertJob(newJob);
    }

    protected void leaveMultiInstance(ProcessEngineConfigurationImpl processEngineConfiguration, ExecutionEntity execution, ParallelMultiInstanceBehavior parallelMultiInstanceBehavior) {
        boolean multiInstanceCompleted = parallelMultiInstanceBehavior.leaveAsync(execution);
        if (!multiInstanceCompleted) {
            this.reCreateJob(processEngineConfiguration, execution);
        }
    }
}

