/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentReadNodeGen;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class JSGuardDisconnectedArgumentRead
extends JavaScriptNode
implements RepeatableNode,
ReadNode {
    private final int index;
    @Node.Child
    @Executed
    JavaScriptNode argumentsArrayNode;
    @Node.Child
    private ReadElementNode readElementNode;
    private final FrameSlot slot;

    JSGuardDisconnectedArgumentRead(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, FrameSlot slot) {
        this.index = index;
        this.argumentsArrayNode = argumentsArray;
        this.readElementNode = readElementNode;
        this.slot = slot;
    }

    public static JSGuardDisconnectedArgumentRead create(int index, ReadElementNode readElementNode, JavaScriptNode argumentsArray, FrameSlot slot) {
        return JSGuardDisconnectedArgumentReadNodeGen.create(index, readElementNode, argumentsArray, slot);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ReadVariableTag.class || tag == StandardTags.ReadVariableTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", this.slot.getIdentifier());
        descriptor.addProperty("readVariableName", this.slot.getIdentifier());
        return descriptor;
    }

    @Specialization(guards={"!isArgumentsDisconnected(argumentsArray)"})
    public Object doObject(DynamicObject argumentsArray, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (unconnected.profile(this.index >= JSArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            return Undefined.instance;
        }
        return this.readElementNode.executeWithTargetAndIndex((Object)argumentsArray, this.index);
    }

    public final int getIndex() {
        return this.index;
    }

    @Specialization(guards={"isArgumentsDisconnected(argumentsArray)"})
    public Object doObjectDisconnected(DynamicObject argumentsArray, @Cached(value="createBinaryProfile()") ConditionProfile wasDisconnected, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsArray.isJSArgumentsObject(argumentsArray));
        if (wasDisconnected.profile(JSArgumentsArray.wasIndexDisconnected(argumentsArray, this.index))) {
            return JSArgumentsArray.getDisconnectedIndexValue(argumentsArray, this.index);
        }
        if (unconnected.profile(this.index >= JSArgumentsArray.getConnectedArgumentCount(argumentsArray))) {
            return Undefined.instance;
        }
        return this.readElementNode.executeWithTargetAndIndex((Object)argumentsArray, this.index);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSGuardDisconnectedArgumentReadNodeGen.create(this.index, JSGuardDisconnectedArgumentRead.cloneUninitialized(this.readElementNode, materializedTags), JSGuardDisconnectedArgumentRead.cloneUninitialized(this.argumentsArrayNode, materializedTags), this.slot);
    }
}

