/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSGlobalObject;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;

public final class JSGlobal
extends JSNonProxy {
    public static final String CLASS_NAME = "global";
    public static final String EVAL_NAME = "eval";
    public static final JSGlobal INSTANCE = new JSGlobal();

    private JSGlobal() {
    }

    public static DynamicObject create(JSRealm realm, DynamicObject objectPrototype) {
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = realm.getContext();
        JSObjectFactory factory = context.getGlobalObjectFactory();
        JSGlobalObject global = new JSGlobalObject(factory.getShape(realm));
        factory.initProto(global, objectPrototype);
        JSObjectUtil.putToStringTag(global, CLASS_NAME);
        return global;
    }

    public static Shape makeGlobalObjectShape(JSContext context, DynamicObject objectPrototype) {
        boolean singleContext = !context.isMultiContext();
        Shape globalObjectShape = JSShape.newBuilder(context, INSTANCE, (DynamicObject)(singleContext ? objectPrototype : null)).propertyAssumptions(singleContext).build();
        if (singleContext) {
            globalObjectShape = Shape.newBuilder((Shape)globalObjectShape).addConstantProperty((Object)JSObject.HIDDEN_PROTO, (Object)objectPrototype, 0).build();
        }
        return globalObjectShape;
    }

    public static DynamicObject createGlobalScope(JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return new JSGlobalObject(context.getGlobalScopeShape());
    }

    public static boolean isJSGlobalObject(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSGlobal.isJSGlobalObject((DynamicObject)obj);
    }

    public static boolean isJSGlobalObject(DynamicObject obj) {
        return JSGlobal.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        if (JSObject.getPrototype(thisObj) == newPrototype) {
            return true;
        }
        JSObject.getJSContext(thisObj).getGlobalObjectPristineAssumption().invalidate();
        return super.setPrototypeOf(thisObj, newPrototype);
    }
}

