/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.List;

public final class JSInteropUtil {
    private JSInteropUtil() {
    }

    public static long getArraySize(Object foreignObj, InteropLibrary interop, Node originatingNode) {
        try {
            return interop.getArraySize(foreignObj);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(foreignObj, (InteropException)((Object)e), "getArraySize", originatingNode);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(Object obj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            return JSObject.get((DynamicObject)((JSDynamicObject)((Object)obj)), key);
        }
        return JSInteropUtil.readMemberOrDefault(obj, key, (Object)Undefined.instance);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object get(Object obj, long index) {
        if (JSDynamicObject.isJSDynamicObject(obj)) {
            return JSObject.get((DynamicObject)((JSDynamicObject)((Object)obj)), index);
        }
        return JSInteropUtil.readArrayElementOrDefault(obj, index, (Object)Undefined.instance);
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue) {
        return JSInteropUtil.readMemberOrDefault(obj, member, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached(), null);
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue, InteropLibrary interop, ImportValueNode importValue, Node originatingNode) {
        if (!(member instanceof String)) {
            return defaultValue;
        }
        try {
            return importValue.executeWithTarget(interop.readMember(obj, (String)member));
        }
        catch (UnknownIdentifierException e) {
            return defaultValue;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "readMember", member, originatingNode);
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue, InteropLibrary interop, ImportValueNode importValue, Node originatingNode) {
        try {
            return importValue.executeWithTarget(interop.readArrayElement(obj, index));
        }
        catch (InvalidArrayIndexException e) {
            return defaultValue;
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)((Object)e), "readArrayElement", index, originatingNode);
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue) {
        return JSInteropUtil.readArrayElementOrDefault(obj, index, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached(), null);
    }

    public static void writeMember(Object obj, Object member, Object value) {
        JSInteropUtil.writeMember(obj, member, value, InteropLibrary.getUncached(), ExportValueNode.getUncached(), null);
    }

    public static void writeMember(Object obj, Object member, Object value, InteropLibrary interop, ExportValueNode exportValue, Node originatingNode) {
        if (!(member instanceof String)) {
            return;
        }
        try {
            interop.writeMember(obj, (String)member, exportValue.execute(value));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "writeMember", member, originatingNode);
        }
    }

    public static Object toPrimitiveOrDefault(Object obj, Object defaultValue, InteropLibrary interop, Node originatingNode) {
        if (interop.isNull(obj)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(obj)) {
                return interop.asBoolean(obj);
            }
            if (interop.isString(obj)) {
                return interop.asString(obj);
            }
            if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    return interop.asInt(obj);
                }
                if (interop.fitsInLong(obj)) {
                    return interop.asLong(obj);
                }
                if (interop.fitsInDouble(obj)) {
                    return interop.asDouble(obj);
                }
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(obj, (InteropException)((Object)e), originatingNode);
        }
        return defaultValue;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> keys(Object obj) {
        try {
            Object keysObj = InteropLibrary.getUncached().getMembers(obj);
            InteropLibrary keysInterop = InteropLibrary.getUncached((Object)keysObj);
            long size = keysInterop.getArraySize(keysObj);
            if (size < 0L || size >= Integer.MAX_VALUE) {
                throw Errors.createRangeErrorInvalidArrayLength();
            }
            ArrayList<Object> keys = new ArrayList<Object>((int)size);
            int i = 0;
            while ((long)i < size) {
                Object key = keysInterop.readArrayElement(keysObj, (long)i);
                assert (InteropLibrary.getUncached().isString(key));
                keys.add(key);
                ++i;
            }
            return keys;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "readArrayElement", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(Object obj, Object key) {
        if (key instanceof String) {
            return InteropLibrary.getUncached().isMemberExisting(obj, (String)key);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean remove(Object obj, Object key) {
        if (key instanceof String) {
            try {
                InteropLibrary.getUncached().removeMember(obj, (String)key);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw Errors.createTypeErrorInteropException(obj, (InteropException)e, "removeMember", key, null);
            }
            return true;
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object call(Object function, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().execute(function, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(function, (InteropException)e, "execute", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object construct(Object target, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().instantiate(target, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw Errors.createTypeErrorInteropException(target, (InteropException)e, "instantiate", null);
        }
    }

    public static boolean isBoxedPrimitive(Object receiver, InteropLibrary interop) {
        return interop.isString(receiver) || interop.isNumber(receiver) || interop.isBoolean(receiver);
    }
}

