/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.drag.service.a;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.modules.drag.config.page.DragPage;
import org.jeecg.modules.drag.dao.JimuDragCategoryDao;
import org.jeecg.modules.drag.dao.OnlDragPageCompDao;
import org.jeecg.modules.drag.dao.OnlDragPageDao;
import org.jeecg.modules.drag.entity.JimuDragCategory;
import org.jeecg.modules.drag.entity.OnlDragPage;
import org.jeecg.modules.drag.service.IJimuDragCategoryService;
import org.jeecg.modules.drag.util.h;
import org.jeecg.modules.drag.vo.OnlDragRecycleVo;
import org.jeecg.modules.drag.vo.TreeModel;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="jimuDragCategoryServiceImpl")
public class a
implements IJimuDragCategoryService {
    @Autowired
    private JimuDragCategoryDao jimuDragCategoryDao;
    @Autowired
    private OnlDragPageDao onlDragPageDao;
    @Autowired
    private OnlDragPageCompDao onlDragPageCompDao;

    @Override
    public JimuDragCategory getById(String id) {
        return this.jimuDragCategoryDao.get(id);
    }

    @Override
    public List<TreeModel> queryList(JimuDragCategory category) {
        List<JimuDragCategory> categoryList = this.jimuDragCategoryDao.queryList(category);
        ArrayList<TreeModel> treeList = new ArrayList<TreeModel>();
        categoryList.forEach(item -> {
            TreeModel treeModel = new TreeModel(item.getId(), item.getParentId(), item.getId(), item.getName(), item.getIzLeaf());
            treeList.add(treeModel);
        });
        return treeList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(JimuDragCategory category) {
        String parentId = category.getParentId();
        category.setIzLeaf(1);
        String sourceType = category.getSourceType();
        if (h.c((Object)sourceType)) {
            category.setSourceType("drag");
        }
        category.setDelFlag(org.jeecg.modules.drag.a.a.h);
        category.setUpdateTime(new Date());
        this.jimuDragCategoryDao.insert(category);
        if (StringUtils.isNotBlank((CharSequence)parentId) && !parentId.equals("0")) {
            JimuDragCategory jimuDragCategory = this.jimuDragCategoryDao.get(parentId);
            jimuDragCategory.setIzLeaf(0);
            this.jimuDragCategoryDao.update(jimuDragCategory);
        }
    }

    @Override
    public void updateById(JimuDragCategory category) {
        this.jimuDragCategoryDao.update(category);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JimuDragCategory updateDelFlag(Integer delFlag, String id) {
        JimuDragCategory jimuDragCategory = this.jimuDragCategoryDao.get(id);
        jimuDragCategory.setDelFlag(delFlag);
        this.jimuDragCategoryDao.update(jimuDragCategory);
        String parentId = jimuDragCategory.getParentId();
        if (StringUtils.isNotBlank((CharSequence)parentId) && !parentId.equals("0")) {
            int count = this.jimuDragCategoryDao.countByParentId(parentId);
            JimuDragCategory parentCategory = this.jimuDragCategoryDao.get(parentId);
            parentCategory.setIzLeaf(count == 0 ? 1 : 0);
            this.jimuDragCategoryDao.update(parentCategory);
        }
        Integer realDelFlag = delFlag == org.jeecg.modules.drag.a.a.g ? org.jeecg.modules.drag.a.a.i : delFlag;
        this.a(id, realDelFlag);
        return jimuDragCategory;
    }

    @Override
    public DragPage<OnlDragRecycleVo> queryRecycleList(OnlDragRecycleVo recycleVo, Integer pageNo, Integer pageSize) {
        MiniDaoPage<OnlDragRecycleVo> pageList = this.jimuDragCategoryDao.queryRecycleBin(recycleVo, pageNo, pageSize);
        return new DragPage<OnlDragRecycleVo>(pageList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void physicalDelete(String id) {
        this.jimuDragCategoryDao.delete(id);
        List<String> ids = this.onlDragPageDao.queryIdByType(id);
        if (!CollectionUtils.isEmpty(ids)) {
            this.onlDragPageCompDao.deleteByPageIds(ids);
            this.onlDragPageDao.deleteByIds(ids);
        }
        this.a(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clearRecovery(JimuDragCategory jimuDragCategory) {
        String dragType;
        List<String> ids;
        String sourceType;
        Integer delFlag = jimuDragCategory.getDelFlag();
        List<String> categoryIdList = this.jimuDragCategoryDao.queryIdList(delFlag, sourceType = jimuDragCategory.getSourceType());
        if (!CollectionUtils.isEmpty(categoryIdList)) {
            for (String id : categoryIdList) {
                this.jimuDragCategoryDao.delete(id);
                ids = this.onlDragPageDao.queryIdByType(id);
                if (!CollectionUtils.isEmpty(ids)) {
                    this.onlDragPageCompDao.deleteByPageIds(ids);
                    this.onlDragPageDao.deleteByIds(ids);
                }
                this.a(id);
            }
        }
        if (h.d((Object)(dragType = jimuDragCategory.getDragType()))) {
            OnlDragPage onlDragPage = new OnlDragPage();
            onlDragPage.setDelFlag(org.jeecg.modules.drag.a.a.g);
            onlDragPage.setStyle(jimuDragCategory.getDragType());
            ids = this.onlDragPageDao.queryIdList(onlDragPage);
            if (!CollectionUtils.isEmpty(ids)) {
                this.onlDragPageCompDao.deleteByPageIds(ids);
                this.onlDragPageDao.deleteByIds(ids);
            }
        }
    }

    @Override
    public Map<String, Integer> queryRecycleCount(OnlDragRecycleVo recycleVo) {
        List<Map<String, Integer>> countList = this.jimuDragCategoryDao.queryRecycleCount(recycleVo);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (!CollectionUtils.isEmpty(countList)) {
            map.put("categoryTotal", h.a((Object)countList.get(0).get("total"), 0));
            map.put("dragTotal", h.a((Object)countList.get(1).get("total"), 0));
        }
        return map;
    }

    @Override
    public Map<String, Integer> queryCountById(String id) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> childIds = this.jimuDragCategoryDao.getChildIds(id);
        List<String> dragIds = this.onlDragPageDao.queryIdByType(id);
        Integer categoryNum = h.a((Object)childIds.size(), 0);
        Integer dragNum = h.a((Object)dragIds.size(), 0);
        Integer[] result = this.a(childIds);
        categoryNum = categoryNum + result[0];
        dragNum = dragNum + result[1];
        map.put("categoryNum", categoryNum);
        map.put("dragNum", dragNum);
        return map;
    }

    private Integer[] a(List<String> ids) {
        Integer categoryNum = 0;
        Integer dragNum = 0;
        if (h.d(ids)) {
            for (String id : ids) {
                List<String> childIds = this.jimuDragCategoryDao.getChildIds(id);
                List<String> dragIds = this.onlDragPageDao.queryIdByType(id);
                categoryNum = categoryNum + h.a((Object)childIds.size(), 0);
                dragNum = dragNum + h.a((Object)dragIds.size(), 0);
                if (!h.d(childIds)) continue;
                Integer[] subResult = this.a(childIds);
                categoryNum = categoryNum + subResult[0];
                dragNum = dragNum + subResult[1];
            }
        }
        return new Integer[]{categoryNum, dragNum};
    }

    private void a(String id, Integer delFlag) {
        List<String> childIds = this.jimuDragCategoryDao.getChildIds(id);
        for (String categoryId : childIds) {
            this.jimuDragCategoryDao.updateDelFlagById(categoryId, delFlag);
            this.a(categoryId, delFlag);
        }
    }

    private void a(String id) {
        List<String> childIds = this.jimuDragCategoryDao.getChildIds(id);
        for (String categoryId : childIds) {
            this.b(categoryId);
        }
    }

    private void b(String id) {
        if (h.d((Object)id)) {
            this.jimuDragCategoryDao.delete(id);
            List<String> ids = this.onlDragPageDao.queryIdByType(id);
            if (!CollectionUtils.isEmpty(ids)) {
                this.onlDragPageCompDao.deleteByPageIds(ids);
                this.onlDragPageDao.deleteByIds(ids);
            }
            this.a(id);
        }
    }
}

