/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.automate.service.a;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.jeecg.modules.jmreport.automate.c.b;
import org.jeecg.modules.jmreport.automate.model.JimuReportAutoExportVO;
import org.jeecg.modules.jmreport.automate.service.IJimuReportAutoService;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.DateUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.i;
import org.jeecg.modules.jmreport.common.util.k;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportExportJobDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportExportLogDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportExportJob;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportExportLog;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.util.h;
import org.jeecg.modules.jmreport.desreport.util.r;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service(value="jimuReportAutoServiceImpl")
public class a
implements IJimuReportAutoService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(a.class);
    @Autowired
    org.jeecg.modules.jmreport.automate.conf.a automateConfigBean;
    @Autowired
    JmReportBaseConfig jmReportBaseConfig;
    @Autowired
    org.jeecg.modules.jmreport.automate.a.a autoAsyncTasks;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    b pyExecHandler;
    @Autowired
    JimuReportExportLogDao jimuReportExportLogDao;
    @Autowired
    JimuReportExportJobDao jimuReportExportJobDao;
    @Qualifier(value="jmTaskScheduler")
    @Autowired
    private TaskScheduler taskScheduler;
    @Autowired
    private org.jeecg.modules.jmreport.automate.conf.a jimuRepAutomateConfigBean;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    private final Map<String, ScheduledFuture<?>> b = new ConcurrentHashMap();

    @Override
    public Result<?> autoExport(JimuReportAutoExportVO jimuReportAutoExportVO, boolean useScript) {
        String exportFrom;
        if (null == jimuReportAutoExportVO) {
            return Result.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReportParams()) && OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReportIds())) {
            return Result.error("\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getReceiverEmail()) && OkConvertUtils.isEmpty(exportFrom = jimuReportAutoExportVO.getExportFrom()) && !"job".equals(exportFrom)) {
            return Result.error("\u8bf7\u8f93\u5165\u63a5\u6536\u901a\u77e5\u7684\u90ae\u7bb1\u5730\u5740");
        }
        if (OkConvertUtils.isEmpty(jimuReportAutoExportVO.getExportType())) {
            jimuReportAutoExportVO.setExportType("PDF");
        }
        if (!useScript) {
            String pluginDomain = this.automateConfigBean.getExport().getPluginDomain();
            if (OkConvertUtils.isEmpty(pluginDomain)) {
                return Result.error("\u8bf7\u914d\u7f6e\u63d2\u4ef6\u5730\u5740\u548c\u7aef\u53e3");
            }
            String testUrl = String.format("%s/export/conn/test", pluginDomain);
            try {
                r.a(testUrl, Result.class);
            }
            catch (RestClientException e2) {
                a.error(e2.getMessage(), (Throwable)e2);
                return Result.error("\u8fde\u63a5\u5bfc\u51fa\u63d2\u4ef6\u5931\u8d25,\u8bf7\u68c0\u67e5\u63d2\u4ef6\u662f\u5426\u6b63\u5e38\u542f\u52a8.");
            }
        }
        String batchNo = DateUtils.b(new Date(), "yyyyMMddHHmmss") + k.getInstance().a(6);
        jimuReportAutoExportVO.setBatchNo(batchNo);
        this.autoAsyncTasks.a(jimuReportAutoExportVO, useScript);
        return Result.OK("\u5df2\u542f\u52a8\u540e\u53f0\u5bfc\u51fa\u4efb\u52a1", batchNo);
    }

    @Override
    public Result<?> autoExport(JimuReportAutoExportVO jimuReportAutoExportVO) {
        Result<?> result = this.autoAsyncTasks.a(jimuReportAutoExportVO);
        if (result.isSuccess()) {
            return this.download(result.getResult().toString(), null);
        }
        return result;
    }

    @Override
    public Result<?> download(String batchNo, String signature) {
        Object zipFileName;
        Object zipFilePath;
        String downloadPath;
        if (OkConvertUtils.isEmpty(batchNo)) {
            return Result.error("\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (batchNo.length() < 6) {
            return Result.error("\u6279\u6b21\u53f7\u9519\u8bef");
        }
        int expiredDay = this.automateConfigBean.getExport().getExpired();
        if (expiredDay > 0) {
            try {
                long dirCreateTime = Long.parseLong(batchNo.trim().substring(0, batchNo.length() - 6));
                if (DateUtils.a(DateUtils.DiffType.b, new Date(), new Date(dirCreateTime)) > (long)expiredDay) {
                    return Result.error("\u56e0\u8d85\u8fc7\u6709\u6548\u671f,\u8be5\u6587\u4ef6\u5df2\u88ab\u6e05\u7406");
                }
            }
            catch (NumberFormatException e2) {
                return Result.error("\u6279\u6b21\u53f7\u9519\u8bef");
            }
        }
        JimuReportExportLog exportLog = this.jimuReportExportLogDao.getByBatchNo(batchNo);
        if (OkConvertUtils.isNotEmpty(signature)) {
            this.a(exportLog, signature);
        }
        if ((downloadPath = exportLog.getDownloadPath()).endsWith(".zip")) {
            zipFilePath = downloadPath;
            zipFileName = FilenameUtils.getName((String)downloadPath);
        } else {
            File batchDownloadPathF = new File(downloadPath);
            if (!batchDownloadPathF.exists()) {
                throw new JimuReportException("\u4e0b\u8f7d\u76ee\u5f55\u4e0d\u5b58\u5728");
            }
            zipFileName = batchNo + ".zip";
            zipFilePath = downloadPath + File.separator + (String)zipFileName;
            try {
                i.a((String)zipFilePath, downloadPath);
            }
            catch (Exception e3) {
                a.error(e3.getMessage(), (Throwable)e3);
                throw new JimuReportException("\u538b\u7f29\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u76ee\u5f55\uff0c\u6216\u67e5\u770b\u540e\u53f0\u65e5\u5fd7");
            }
        }
        i.a(this.response, (String)zipFilePath, (String)zipFileName);
        return null;
    }

    private void a(JimuReportExportLog exportLog, String signature) {
        if (OkConvertUtils.isEmpty(signature)) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u6587\u4ef6\u7b7e\u540d\u4e3a\u7a7a.");
            throw new JimuReportException("\u975e\u6cd5\u8bf7\u6c42");
        }
        if (exportLog == null) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728.");
            throw new JimuReportException("\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        String id = exportLog.getId();
        if (!signature.trim().equals(org.jeecg.modules.jmreport.automate.a.a.a(id, exportLog.getBatchNo()))) {
            a.error("\u4e0b\u8f7d\u6279\u91cf\u5bfc\u51fa\u62a5\u8868\u5931\u8d25:\u6587\u4ef6\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25.");
            throw new JimuReportException("\u975e\u6cd5\u8bf7\u6c42");
        }
        exportLog.setUpdateTime(new Date());
    }

    @Override
    public Result<?> queryExportLogs(Integer pageNo, Integer pageSize, String batchNo, String fromId) {
        try {
            JimuReportExportLog jimuReportExportLog = new JimuReportExportLog();
            if (OkConvertUtils.isNotEmpty(batchNo)) {
                batchNo = "%" + (String)batchNo + "%";
            }
            jimuReportExportLog.setBatchNo((String)batchNo);
            jimuReportExportLog.setFromId(fromId);
            if ("tenant".equals(this.jmReportBaseConfig.getSaasMode())) {
                String tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
                jimuReportExportLog.setTenantId(tenantId);
            }
            MiniDaoPage<JimuReportExportLog> page = this.jimuReportExportLogDao.pageList(jimuReportExportLog, pageNo, pageSize);
            JmPage<?> jmPage = h.a(page);
            return Result.OK(jmPage);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Result<?> deleteExportLog(String id) {
        this.jimuReportExportLogDao.deleteById(id);
        return Result.OK("\u5220\u9664\u6210\u529f", true);
    }

    @PostConstruct
    public void a() {
        if (!this.jimuRepAutomateConfigBean.getExport().b()) {
            return;
        }
        List<Object> jobs = new ArrayList();
        try {
            jobs = this.jimuReportExportJobDao.queryAllByStatus(1);
        }
        catch (Throwable e2) {
            if (e2.getCause() instanceof SQLSyntaxErrorException && e2.getMessage().contains("doesn't exist")) {
                a.error("\u5bfc\u51fa\u4efb\u52a1\u8868(jimu_report_export_job)\u4e0d\u5b58\u5728\uff0c\u5b9a\u65f6\u5bfc\u51fa\u62a5\u8868\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002");
            }
            a.error(e2.getMessage(), e2);
        }
        for (JimuReportExportJob jimuReportExportJob : jobs) {
            try {
                this.a(jimuReportExportJob);
            }
            catch (Exception e3) {
                a.warn("\u542f\u52a8\u5b9a\u65f6\u5bfc\u51fa\u4efb\u52a1\u5931\u8d25:" + jimuReportExportJob.getId() + e3.getMessage(), (Throwable)e3);
            }
        }
    }

    private Result<?> a(JimuReportExportJob task) {
        if (!this.jimuRepAutomateConfigBean.getExport().b()) {
            return Result.error("\u8bf7\u5148\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u5f00\u542f\u81ea\u52a8\u5bfc\u51fa\u529f\u80fd\u3002(jeecg.jmreport.automate.export.enable-auto-export)");
        }
        if (this.b.containsKey(task.getId())) {
            return Result.OK();
        }
        Date now = new Date();
        if (OkConvertUtils.isNotEmpty(task.getEndTime()) && task.getEndTime().before(now)) {
            return Result.error("\u5df2\u7ecf\u8d85\u8fc7\u622a\u6b62\u65f6\u95f4");
        }
        if (OkConvertUtils.isEmpty(task.getReportConf())) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        try {
            JSONArray reportConfs = JSONObject.parseArray((String)task.getReportConf());
            if (reportConfs.isEmpty()) {
                return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
            }
        }
        catch (Exception e2) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868");
        }
        Runnable taskRunnable = () -> this.b(task);
        if (!CronExpression.isValidExpression((String)task.getExecInterval())) {
            return Result.error("\u6267\u884c\u9891\u7387\u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684Cron\u8868\u8fbe\u5f0f");
        }
        CronTrigger cronTrigger = new CronTrigger(task.getExecInterval());
        ScheduledFuture future = this.taskScheduler.schedule(taskRunnable, (Trigger)cronTrigger);
        this.b.put(task.getId(), future);
        return Result.OK();
    }

    private Result<?> b(JimuReportExportJob task) {
        Result<?> result = this.c(task);
        Date now = new Date();
        if (!result.isSuccess()) {
            a.error(result.getMessage());
        }
        task.setLastRunTime(now);
        this.jimuReportExportJobDao.update(task);
        if (OkConvertUtils.isNotEmpty(task.getEndTime()) && task.getEndTime().before(now)) {
            this.a(task.getId());
        }
        return result;
    }

    private Result<?> c(JimuReportExportJob task) {
        if (OkConvertUtils.isNotEmpty(task.getBeginTime()) && task.getBeginTime().after(new Date())) {
            return Result.error("\u672a\u5230\u5f00\u59cb\u65f6\u95f4");
        }
        String reportConf = task.getReportConf();
        if (OkConvertUtils.isEmpty(reportConf)) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        JSONArray reportConfArr = null;
        try {
            reportConfArr = JSONArray.parseArray((String)reportConf);
        }
        catch (Exception e2) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        if (OkConvertUtils.isEmpty(reportConfArr)) {
            return Result.error("\u8bf7\u5148\u914d\u7f6e\u62a5\u8868");
        }
        ArrayList<JimuReportAutoExportVO.a> exportReportDetailList = new ArrayList<JimuReportAutoExportVO.a>();
        reportConfArr.stream().map(o2 -> (JSONObject)o2).forEach(o2 -> {
            String reportId = o2.getString("reportId");
            JimuReportAutoExportVO.a exportReportDetail = new JimuReportAutoExportVO.a();
            exportReportDetail.setId(reportId);
            Object paramsObj = o2.get((Object)"params");
            HashMap<String, String> params = new HashMap();
            if (OkConvertUtils.isNotEmpty(paramsObj)) {
                params = (Map)TypeUtils.castToJavaBean((Object)paramsObj, Map.class);
            }
            if (OkConvertUtils.isNotEmpty(params)) {
                exportReportDetail.setParams(params);
            }
            if (OkConvertUtils.isNotEmpty(o2.get((Object)"exportType"))) {
                exportReportDetail.setExportType(o2.getString("exportType"));
            }
            exportReportDetailList.add(exportReportDetail);
        });
        JimuReportAutoExportVO exportVO = new JimuReportAutoExportVO();
        if (OkConvertUtils.isNotEmpty(task.getReceiverEmail())) {
            exportVO.setReceiverEmail(task.getReceiverEmail());
        }
        exportVO.setReportParams(exportReportDetailList);
        exportVO.setExportType("pdf");
        exportVO.setExportFrom("job");
        exportVO.setFromId(task.getId());
        exportVO.setFromName(task.getName());
        String apiBasePath = this.jmReportBaseConfig.getApiBasePath();
        if (OkConvertUtils.isNotEmpty(apiBasePath)) {
            exportVO.setDomain(apiBasePath);
        }
        if (OkConvertUtils.isNotEmpty(task.getFileSyncPath())) {
            exportVO.setFileSyncPath(task.getFileSyncPath());
        }
        return this.autoAsyncTasks.a(exportVO);
    }

    public Result<?> a(String jobId) {
        ScheduledFuture<?> future = this.b.get(jobId);
        if (future != null) {
            boolean success = future.cancel(true);
            if (success) {
                this.b.remove(jobId);
                return Result.OK();
            }
            return Result.error("\u64cd\u4f5c\u5931\u8d25");
        }
        return Result.OK();
    }

    @Override
    public Result<?> queryExportJob(Integer pageNo, Integer pageSize, String name) {
        try {
            JimuReportExportJob jimuReportExportJob = new JimuReportExportJob();
            if (OkConvertUtils.isNotEmpty(name)) {
                name = "%" + (String)name + "%";
            }
            jimuReportExportJob.setName((String)name);
            if ("tenant".equals(this.jmReportBaseConfig.getSaasMode())) {
                String tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
                jimuReportExportJob.setTenantId(tenantId);
            }
            MiniDaoPage<JimuReportExportJob> page = this.jimuReportExportJobDao.pageList(jimuReportExportJob, pageNo, pageSize);
            JmPage<?> jmPage = h.a(page);
            return Result.OK(jmPage);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public Result<?> getExportJobDetail(String id) {
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(id);
        return Result.OK(jimuReportExportJob);
    }

    @Override
    public Result<?> saveExportJob(JimuReportExportJob jimuReportExportJob) {
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getBeginTime())) {
            jimuReportExportJob.setBeginTime(new Date());
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getStatus())) {
            jimuReportExportJob.setStatus(0);
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getExecInterval())) {
            return Result.error("\u8bf7\u8f93\u5165\u6267\u884c\u9891\u7387");
        }
        if (!CronExpression.isValidExpression((String)jimuReportExportJob.getExecInterval())) {
            return Result.error("\u6267\u884c\u9891\u7387\u9700\u8981\u4f7f\u7528\u6b63\u786e\u7684Cron\u8868\u8fbe\u5f0f");
        }
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getFileSyncPath()) && !i.c(jimuReportExportJob.getFileSyncPath())) {
            return Result.error("\u540c\u6b65\u76ee\u5f55\u4e0d\u53ef\u4ee5\u4f7f\u7528\u4e0a\u4e00\u7ea7\u8def\u5f84(../)");
        }
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getId())) {
            this.jimuReportExportJobDao.insert(jimuReportExportJob);
        } else {
            this.jimuReportExportJobDao.update(jimuReportExportJob);
        }
        return Result.OK();
    }

    @Override
    public Result<?> deleteExportJob(String id) {
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(id);
        if (OkConvertUtils.isEmpty(jimuReportExportJob)) {
            return Result.OK();
        }
        if (OkConvertUtils.isNotEmpty(jimuReportExportJob.getStatus()) && 1 == jimuReportExportJob.getStatus()) {
            return Result.error("\u4e0d\u80fd\u5220\u9664\u542f\u52a8\u4e2d\u7684\u5bfc\u51fa\u4efb\u52a1");
        }
        int i2 = this.jimuReportExportJobDao.deleteById(id);
        if (i2 > 0) {
            return Result.OK();
        }
        return Result.error("\u5220\u9664\u5931\u8d25");
    }

    @Override
    public Result<?> updateExportJobStatus(JimuReportExportJob jimuReportExportJob) {
        if (OkConvertUtils.isEmpty(jimuReportExportJob.getId())) {
            return Result.error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JimuReportExportJob jobData = this.jimuReportExportJobDao.get(jimuReportExportJob.getId());
        if (OkConvertUtils.isEmpty(jobData)) {
            return Result.error("\u5bfc\u51fa\u8ba1\u5212\u6570\u636e\u4e0d\u5b58\u5728");
        }
        jobData.setStatus(jimuReportExportJob.getStatus());
        Result<Object> result = Result.error("\u64cd\u4f5c\u5931\u8d25");
        result = 1 == jobData.getStatus() ? this.a(jobData) : this.a(jobData.getId());
        if (result.isSuccess()) {
            this.jimuReportExportJobDao.update(jobData);
        }
        return result;
    }

    @Override
    public Result<?> runNow(String jobId) {
        if (OkConvertUtils.isEmpty(jobId)) {
            return Result.error("\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u4efb\u52a1");
        }
        JimuReportExportJob jimuReportExportJob = this.jimuReportExportJobDao.get(jobId);
        if (OkConvertUtils.isEmpty(jimuReportExportJob)) {
            return Result.error("\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        return this.b(jimuReportExportJob);
    }
}

