/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.wrapper.BodyReaderHttpServletRequestWrapper;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportSignatureInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JimuReportSignatureInterceptor.class);
    public static final String X_SIGN = "X-Sign";
    public static final String X_TIMESTAMP = "X-TIMESTAMP";
    public static final String DEFAULT_SECRET = "aa05f1c54d63749eda95f9fa6d49v442a";
    private static final long MAX_EXPIRE = 300L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        JmReportBaseConfig jmConfig = JimuSpringContextUtils.getBean(JmReportBaseConfig.class);
        if (this.isSafeMode(jmConfig).booleanValue()) {
            String xTimeStamp = request.getHeader(X_TIMESTAMP);
            String headerSign = request.getHeader(X_SIGN);
            Long clientTimestamp = Long.parseLong(xTimeStamp);
            if (System.currentTimeMillis() - clientTimestamp > 300000L) {
                log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
                this.error(response, "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
                return false;
            }
            BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(request);
            SortedMap<String, String> map = this.getQueryParams(requestWrapper);
            String paramsJsonStr = JSONObject.toJSONString(map);
            String signValue = DigestUtils.md5DigestAsHex((byte[])(paramsJsonStr + DEFAULT_SECRET).getBytes()).toUpperCase();
            if (!signValue.equals(headerSign)) {
                log.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01Header Sign : {},\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)headerSign, (Object)requestWrapper.getRequestURL().toString());
                this.error(response, "\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u53c2\u6570\u6709\u8bef\uff01");
                return false;
            }
        }
        return true;
    }

    private void error(HttpServletResponse response, String msg) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        Result<Object> result = Result.error(msg);
        result.setCode(1001);
        out.print(JSON.toJSON(result));
    }

    private SortedMap<String, String> getQueryParams(BodyReaderHttpServletRequestWrapper request) {
        String body;
        TreeMap<String, String> resultMap = new TreeMap<String, String>();
        String urlParam = request.getQueryString();
        if (OkConvertUtils.isNotEmpty(urlParam)) {
            String decodeParam = "";
            try {
                decodeParam = URLDecoder.decode(urlParam, "utf-8");
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            String[] arr = decodeParam.split("&");
            for (String s2 : arr) {
                int index = s2.indexOf("=");
                resultMap.put(s2.substring(0, index), s2.substring(index + 1));
            }
        }
        if (RequestMethod.POST.name().equals(request.getMethod()) && OkConvertUtils.isNotEmpty(body = request.getBody())) {
            JSONObject json = JSON.parseObject((String)body);
            for (String key : json.keySet()) {
                String text = json.getString(key);
                resultMap.put(key, text);
            }
        }
        return resultMap;
    }

    private Boolean isSafeMode(JmReportBaseConfig jmConfig) {
        Environment env;
        Boolean safe = jmConfig.getFirewall() != null ? jmConfig.getFirewall().getDataSourceSafe() : false;
        if (safe == null && (safe = (Boolean)(env = JimuSpringContextUtils.getBean(Environment.class)).getProperty("jeecg.safeMode", Boolean.class, (Object)false)) == null) {
            safe = (Boolean)env.getProperty("jeecg.firewall.dataSourceSafe", Boolean.class, (Object)false);
        }
        return safe;
    }

    private String getSignatureSecret(JmReportBaseConfig jmConfig) {
        String signatureSecret = jmConfig.getSignatureSecret();
        if (signatureSecret == null) {
            Environment env = JimuSpringContextUtils.getBean(Environment.class);
            signatureSecret = (String)env.getProperty("jeecg.signatureSecret", String.class, (Object)DEFAULT_SECRET);
        }
        return signatureSecret;
    }
}

