/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

public class JimuI18nUtils {
    private static final Log logger = LogFactory.getLog(JimuI18nUtils.class);
    private static MessageSource messageSource = null;

    public JimuI18nUtils() {
        messageSource = this.messageSource();
    }

    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"file:" + this.getLocalExternalConfigPath(), "classpath:i18n/messages"});
        messageSource.setDefaultEncoding("UTF-8");
        messageSource.setCacheSeconds(3600);
        messageSource.setDefaultLocale(Locale.SIMPLIFIED_CHINESE);
        return messageSource;
    }

    private String getLocalExternalConfigPath() {
        String classPath = this.getClass().getResource("").toString();
        Path basePath = classPath.startsWith("jar:") ? Paths.get(System.getProperty("user.dir"), "config/i18n/messages") : Paths.get("config/i18n/messages", new String[0]).toAbsolutePath();
        return basePath.toString().replace("\\", "/");
    }

    public static String get(String msgKey) {
        String message;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            message = null == messageSource ? msgKey : messageSource.getMessage(msgKey, null, locale);
        }
        catch (NoSuchMessageException e2) {
            logger.warn((Object)e2.getMessage());
            message = msgKey;
        }
        return message;
    }

    public static String getAndReplace(String msgKey, Object ... args) {
        String message;
        Locale locale = LocaleContextHolder.getLocale();
        try {
            message = null == messageSource ? msgKey : messageSource.getMessage(msgKey, args, locale);
        }
        catch (NoSuchMessageException e2) {
            logger.warn((Object)e2.getMessage());
            message = msgKey;
        }
        return message;
    }
}

