/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor.handlers;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.annotation.Logical;
import org.jeecg.modules.jmreport.common.annotation.RequiresPermissions;
import org.jeecg.modules.jmreport.common.annotation.RequiresRoles;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JmIPermissionsVerifyHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JmIPermissionsVerifyHandler.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    private static final Integer GEN_TEST_DATA_CODE = 402;

    public Result<?> verifyPermissions(HttpServletRequest request, RequiresPermissions requiresPermissions) {
        if (requiresPermissions == null) {
            return Result.OK();
        }
        Object[] permissions = requiresPermissions.value();
        String[] userHadPermissions = this.jimuTokenClient.getPermissions(request);
        boolean isAuthorized = false;
        if (OkConvertUtils.isNotEmpty(userHadPermissions) && OkConvertUtils.isNotEmpty(permissions)) {
            Object[] finalPermissions = permissions;
            Logical logical = requiresPermissions.logical();
            isAuthorized = Logical.AND.equals((Object)logical) ? Arrays.stream(finalPermissions).allMatch(code -> OkConvertUtils.isIn(code, userHadPermissions)) : Arrays.stream(userHadPermissions).anyMatch(arg_0 -> JmIPermissionsVerifyHandler.lambda$verifyPermissions$1((String[])finalPermissions, arg_0));
        }
        if (!isAuthorized) {
            if (OkConvertUtils.isEmpty(permissions)) {
                permissions = new String[]{};
            }
            log.error("Subject does not have permission {}", (Object)Arrays.toString(permissions));
        }
        return isAuthorized ? Result.OK() : Result.error("\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u6743\u9650\uff01");
    }

    public Result<?> verifyRoles(HttpServletRequest request, RequiresRoles requiresRoles, String requestPath) {
        if (requiresRoles == null) {
            return Result.OK();
        }
        String[] roleCodes = requiresRoles.value();
        String[] userHasRoles = this.jimuTokenClient.getRoles(request);
        Integer errorCode = 500;
        if (OkConvertUtils.isEmpty(userHasRoles)) {
            log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + requestPath);
            if ("/jmreport/loadTableData".equals(requestPath)) {
                errorCode = GEN_TEST_DATA_CODE;
            }
            return Result.error(errorCode, "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u89d2\u8272\uff01");
        }
        Logical logical = requiresRoles.logical();
        boolean isAuthorized = Logical.AND.equals((Object)logical) ? Arrays.stream(roleCodes).allMatch(code -> OkConvertUtils.isIn(code, userHasRoles)) : Arrays.stream(userHasRoles).anyMatch(code -> OkConvertUtils.isIn(code, roleCodes));
        if (!isAuthorized) {
            log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + requestPath);
            if ("/jmreport/loadTableData".equals(requestPath)) {
                errorCode = GEN_TEST_DATA_CODE;
            }
            return Result.error(errorCode, "\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u89d2\u8272\uff01");
        }
        return Result.OK();
    }

    private static /* synthetic */ boolean lambda$verifyPermissions$1(String[] finalPermissions, String code) {
        return OkConvertUtils.isIn(code, finalPermissions);
    }
}

