/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;

public class JmExpression {
    public static final String REGEX = "^=${expression}\\((.*)\\.(.*)\\)$";
    public static final String[] EXP_TYPES = new String[]{"DBSUM", "DBMAX", "DBMIN", "DBAVERAGE", "dbsum", "dbmax", "dbmin", "dbaverage"};
    public static final String REPLACE_STR = "${expression}";
    private String text;
    private String value;
    private String type;
    private String dbCode;
    private String field;

    public JmExpression() {
    }

    public JmExpression(String str) {
        this.text = str;
        this.value = "";
        for (int i2 = 0; i2 < EXP_TYPES.length; ++i2) {
            String pattern;
            Pattern r2;
            Matcher m2;
            String exp = EXP_TYPES[i2];
            if (str.indexOf(exp) <= 0) continue;
            if (OkConvertUtils.isNotEmpty(str) && (str.contains("#{") || str.contains("${"))) {
                str = str.replaceAll("[#$]\\{|\\}", "");
            }
            if (!(m2 = (r2 = Pattern.compile(pattern = REGEX.replace(REPLACE_STR, exp))).matcher(str)).find()) continue;
            this.type = exp;
            this.dbCode = m2.group(1);
            this.field = m2.group(2);
            break;
        }
    }

    public String getFullSql(String metaSql, String condition) {
        Object temp = "";
        String type = this.type.toUpperCase();
        if (EXP_TYPES[0].equals(type)) {
            temp = "SELECT sum(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[1].equals(type)) {
            temp = "SELECT max(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[2].equals(type)) {
            temp = "SELECT min(" + this.field + ") askey from ( " + metaSql + " )";
        } else if (EXP_TYPES[3].equals(type)) {
            temp = "SELECT avg(" + this.field + ") askey from ( " + metaSql + " )";
        }
        temp = (String)temp + "jeecg_rp_temp";
        if (condition != null && !"".equals(condition)) {
            if (!((String)condition).trim().toLowerCase().startsWith("and")) {
                condition = " and " + (String)condition;
            }
            temp = (String)temp + " where 1=1 " + (String)condition;
        }
        return temp;
    }

    public static Map<String, String> getExpMapByList(List<JmExpression> expList) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        for (JmExpression exp : expList) {
            map.put(exp.getText(), exp.getValue());
            if (!OkConvertUtils.isNotEmpty(exp.getType())) continue;
            map.put(exp.getText().replace(exp.getType(), exp.getType().toLowerCase()), exp.getValue());
        }
        return map;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDbCode() {
        return this.dbCode;
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setDbCode(String dbCode) {
        this.dbCode = dbCode;
    }

    @Generated
    public void setField(String field) {
        this.field = field;
    }

    @Generated
    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof JmExpression)) {
            return false;
        }
        JmExpression other = (JmExpression)o2;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$dbCode = this.getDbCode();
        String other$dbCode = other.getDbCode();
        if (this$dbCode == null ? other$dbCode != null : !this$dbCode.equals(other$dbCode)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JmExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $dbCode = this.getDbCode();
        result = result * 59 + ($dbCode == null ? 43 : $dbCode.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JmExpression(text=" + this.getText() + ", value=" + this.getValue() + ", type=" + this.getType() + ", dbCode=" + this.getDbCode() + ", field=" + this.getField() + ")";
    }
}

