/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSONObject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.firewall.interceptor.enums.ShareUrlEnum;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDbDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportLinkDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportShareDao;
import org.jeecg.modules.jmreport.desreport.entity.JimuReport;
import org.jeecg.modules.jmreport.desreport.entity.JimuReportShare;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDb;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.model.JmReportShareVo;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.jeecg.modules.jmreport.desreport.util.e;
import org.jeecg.modules.jmreport.desreport.util.h;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerMapping;

@Service(value="jimuReportShareServiceImpl")
public class g
implements IJimuReportShareService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(g.class);
    private static final PathMatcher b = new AntPathMatcher();
    @Value(value="${jeecg.shiro.excludeUrls:}")
    private String excludeUrls;
    @Autowired
    private JimuReportShareDao jimuReportShareDao;
    @Autowired
    private JimuReportDao jimuReportDao;
    @Autowired
    private JimuReportDbDao jimuReportDbDao;
    @Autowired
    private JimuReportLinkDao jimuReportLinkDao;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private JmReportTokenClient jimuTokenClient;

    @Override
    public JimuReportShare selectJurisdiction(String reportId) {
        return this.jimuReportShareDao.selectJurisdiction(reportId);
    }

    @Override
    public boolean isSharingEffective(String reportIdUrl, HttpServletRequest request) {
        String[] excludeUrlArr;
        boolean exists = ShareUrlEnum.getShareUrls().stream().anyMatch(url -> b.match(url, reportIdUrl));
        if (exists) {
            String reportId = "";
            if (reportIdUrl.startsWith(ShareUrlEnum.GET_QUERY_INFO.getValue())) {
                String method = request.getMethod();
                reportId = RequestMethod.POST.name().equals(method) ? e.a(request, "reportId") : request.getParameter("reportId");
            } else if (reportIdUrl.startsWith(ShareUrlEnum.SHARE_VERIFICATION.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.DICTCODE_SEARCH.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.MULTIPLE_INIT_VALUE.getValue())) {
                reportId = request.getParameter("reportId");
            } else if (reportIdUrl.startsWith(ShareUrlEnum.QUERYMAP_BY_CODE.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.GET_CHAR_DATA.getValue())) {
                reportId = e.a(request, "reportId");
            } else if (reportIdUrl.startsWith(ShareUrlEnum.EXPORT_PDF_STREAM.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.EXPORT_ALL_EXCEL_STREAM.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.EXPORT_WORD_STREAM.getValue())) {
                reportId = e.a(request, "excelConfigId");
            } else if (reportIdUrl.startsWith(ShareUrlEnum.QUREST_SQL.getValue()) || reportIdUrl.startsWith(ShareUrlEnum.QUREST_API.getValue())) {
                JmReportDb jmReportDb;
                String apiSelectId = e.a(request, "apiSelectId");
                if (OkConvertUtils.isNotEmpty(apiSelectId) && (jmReportDb = this.jimuReportDbDao.get(apiSelectId)) != null) {
                    reportId = jmReportDb.getJimuReportId();
                }
            } else if (reportIdUrl.startsWith(ShareUrlEnum.SHOW_DATA.getValue())) {
                reportId = request.getParameter("id");
                if (OkConvertUtils.isEmpty(reportId)) {
                    reportId = e.a(request, "id");
                }
            } else if (b.match(ShareUrlEnum.FORM_REPEAT_SUBMIT.getValue(), reportIdUrl)) {
                reportId = e.a(request, "reportId");
            } else {
                Map pathVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
                reportId = (String)pathVars.get("id");
                if (OkConvertUtils.isEmpty(reportId)) {
                    reportId = (String)pathVars.get("reportId");
                }
            }
            if (OkConvertUtils.isEmpty(reportId)) {
                return false;
            }
            JimuReportShare jurisdiction = this.selectJurisdiction(reportId);
            if (OkConvertUtils.isNotEmpty(jurisdiction.getShareToken())) {
                return this.isShareingToken(reportIdUrl, request);
            }
            jurisdiction = this.compareToDate(jurisdiction);
            return "0".equals(jurisdiction.getStatus());
        }
        exists = ShareUrlEnum.getDragShareUrls().stream().anyMatch(url -> b.match(url, reportIdUrl));
        if (!exists && OkConvertUtils.isNotEmpty(this.excludeUrls) && OkConvertUtils.isNotEmpty(excludeUrlArr = this.excludeUrls.split(","))) {
            exists = Arrays.stream(excludeUrlArr).anyMatch(excludeUrl -> b.match(excludeUrl, reportIdUrl));
        }
        return exists;
    }

    @Override
    public String getExtractionCode() {
        String str = "0123456789abcdefghijklmnopqrstuvwxyz";
        StringBuilder sb = new StringBuilder(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            char ch = str.charAt(new Random().nextInt(str.length()));
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public JimuReportShare compareToDate(JimuReportShare jurisdiction) {
        Date lastUpdateTime = jurisdiction.getLastUpdateTime();
        String termOfValidity = jurisdiction.getTermOfValidity();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(lastUpdateTime);
        if ("2".equals(termOfValidity)) {
            calendar.add(5, 7);
        } else if ("3".equals(termOfValidity)) {
            calendar.add(5, 1);
        } else {
            return jurisdiction;
        }
        Date time = calendar.getTime();
        Date date = new Date();
        boolean before = date.before(time);
        if (!before) {
            jurisdiction.setStatus("1");
            this.jimuReportShareDao.update(jurisdiction);
            return jurisdiction;
        }
        return jurisdiction;
    }

    @Override
    public String passwordVerification(String reportId, String lock) {
        Long count = this.jimuReportDao.count(reportId);
        if (null == count || 0L == count) {
            return "noExist";
        }
        JimuReportShare jurisdiction = this.jimuReportShareDao.selectJurisdiction(reportId);
        if (null == jurisdiction) {
            return "3";
        }
        this.a(jurisdiction);
        jurisdiction = this.compareToDate(jurisdiction);
        if ("1".equals(jurisdiction.getStatus())) {
            return "1";
        }
        if ("0".equals(jurisdiction.getPreviewLockStatus())) {
            return "0";
        }
        if (OkConvertUtils.isEmpty(lock)) {
            return "2";
        }
        String previewLock = jurisdiction.getPreviewLock();
        if (previewLock.equals(lock)) {
            return "0";
        }
        return "2";
    }

    @Override
    public JimuReportShare addAndEdit(JimuReportShare jurisdiction) {
        String reportId = jurisdiction.getReportId();
        this.a(jurisdiction);
        String previewLockStatus = jurisdiction.getPreviewLockStatus();
        if ("1".equals(previewLockStatus)) {
            String extractionCode = this.getExtractionCode();
            jurisdiction.setPreviewLock(extractionCode);
        }
        JimuReportShare diction = this.jimuReportShareDao.selectJurisdiction(reportId);
        jurisdiction.setLastUpdateTime(new Date());
        if (OkConvertUtils.isNotEmpty(jurisdiction.getStatus()) && "1".equals(jurisdiction.getStatus())) {
            jurisdiction.setPreviewUrl("");
        } else {
            try {
                if (OkConvertUtils.isNotEmpty(jurisdiction.getVerifyShareToken()) && "1".equals(jurisdiction.getVerifyShareToken())) {
                    String mdStr = org.jeecg.modules.jmreport.common.util.g.g(SnowflakeIdWorker.generateId().toString());
                    jurisdiction.setPreviewUrl("/jmreport/shareView/" + jurisdiction.getReportId() + "?shareToken=" + mdStr);
                    jurisdiction.setShareToken(mdStr);
                } else {
                    jurisdiction.setPreviewUrl("/jmreport/shareView/" + jurisdiction.getReportId());
                    jurisdiction.setShareToken("");
                }
            }
            catch (Exception e2) {
                a.error("\u6d4f\u89c8\u94fe\u63a5\u751f\u6210\u5931\u8d25");
                a.error(e2.getMessage(), (Throwable)e2);
            }
        }
        if (null == diction) {
            String uuid = String.valueOf(SnowflakeIdWorker.generateId());
            jurisdiction.setId(uuid);
            this.jimuReportShareDao.insert(jurisdiction);
        } else {
            jurisdiction.setId(diction.getId());
            this.jimuReportShareDao.update(jurisdiction);
        }
        return jurisdiction;
    }

    private void a(JimuReportShare jurisdiction) {
        Object useQueryForm;
        JSONObject jsonObject;
        JimuReport jimuReport;
        JSONObject jsonStrJson;
        String reportId = jurisdiction.getReportId();
        if (OkConvertUtils.isNotEmpty(jurisdiction.getStatus()) && !"1".equals(jurisdiction.getStatus()) && (jsonStrJson = (jimuReport = this.jimuReportDao.get(reportId)).getJsonStrJson()).containsKey((Object)"queryFormSetting") && null != (jsonObject = jsonStrJson.getJSONObject("queryFormSetting")) && jsonObject.containsKey((Object)"useQueryForm") && null != (useQueryForm = jsonObject.get((Object)"useQueryForm")) && Boolean.parseBoolean(useQueryForm.toString())) {
            throw new JimuReportException("\u67e5\u8be2\u586b\u62a5\u7981\u6b62\u5206\u4eab\uff01");
        }
    }

    @Override
    public boolean isShareingToken(String requestPath, HttpServletRequest request) {
        String jmLink;
        Object shareToken = request.getHeader("JmReport-Share-Token");
        Object linkId = "";
        if (OkConvertUtils.isEmpty(shareToken)) {
            shareToken = request.getParameter("shareToken");
        }
        if (OkConvertUtils.isNotEmpty(jmLink = request.getParameter("jmLink"))) {
            try {
                byte[] bytes = Base64.decodeBase64((String)jmLink);
                String str = new String(bytes);
                Object[] split = str.split("\\|\\|");
                if (ArrayUtils.isNotEmpty((Object[])split) && split.length == 2) {
                    shareToken = split[0];
                    linkId = split[1];
                }
            }
            catch (IllegalArgumentException e2) {
                a.error("\u89e3\u5bc6\u5931\u8d25\uff1a" + e2.getMessage());
                a.error(e2.getMessage(), (Throwable)e2);
                return false;
            }
        }
        if (OkConvertUtils.isEmpty(shareToken)) {
            return false;
        }
        JimuReportShare jurisdiction = this.jimuReportShareDao.getShareByShareToken((String)shareToken);
        if (jurisdiction != null) {
            if (!"0".equals((jurisdiction = this.compareToDate(jurisdiction)).getStatus())) {
                return false;
            }
        } else {
            return false;
        }
        if (requestPath.startsWith("/jmreport/view")) {
            if (OkConvertUtils.isNotEmpty(linkId)) {
                Long count = this.jimuReportLinkDao.selectLinkCountByLinkId((String)linkId);
                if (null != count && count > 0L) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public JmPage<JmReportShareVo> getSharePageList(Integer pageNo, Integer pageSize, String reportName, HttpServletRequest request) {
        String username = "";
        String tenantId = "";
        if ("created".equals(this.jmBaseConfig.getSaasMode())) {
            username = OkConvertUtils.getString(this.jimuTokenClient.getUsername(request), "\u83b7\u53d6\u4e0d\u5230\u7528\u6237\u8d26\u53f7");
        }
        if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
            tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
        }
        if (OkConvertUtils.isNotEmpty(reportName)) {
            reportName = "%" + (String)reportName + "%";
        }
        MiniDaoPage<JmReportShareVo> all = this.jimuReportLinkDao.getSharePageList(pageNo, pageSize, (String)reportName, username, tenantId);
        return h.a(all);
    }

    @Override
    public void batchCancelShareByIds(String ids) {
        if (OkConvertUtils.isNotEmpty(ids)) {
            this.jimuReportLinkDao.batchCancelShareByIds(Arrays.asList(ids.split(",")));
        }
    }
}

