/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.promeg.pinyinhelper.Pinyin;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.expetion.JimuFileDsParseException;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.common.util.e;
import org.jeecg.modules.jmreport.common.util.g;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDataSourceDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDbDao;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDbParamDao;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDataSource;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDb;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDbField;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDbParam;
import org.jeecg.modules.jmreport.desreport.express.ExpressUtil;
import org.jeecg.modules.jmreport.desreport.handlers.JimuFileUploadHandler;
import org.jeecg.modules.jmreport.desreport.model.FilesDsTable;
import org.jeecg.modules.jmreport.desreport.model.JmExpression;
import org.jeecg.modules.jmreport.desreport.model.JmPage;
import org.jeecg.modules.jmreport.desreport.render.handler.convert.ApiDataConvertAdapter;
import org.jeecg.modules.jmreport.desreport.render.utils.RegexMatches;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbFieldService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbParamService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbService;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.jeecg.modules.jmreport.desreport.service.IJmreportNoSqlService;
import org.jeecg.modules.jmreport.desreport.util.c;
import org.jeecg.modules.jmreport.desreport.util.h;
import org.jeecg.modules.jmreport.desreport.util.i;
import org.jeecg.modules.jmreport.desreport.util.o;
import org.jeecg.modules.jmreport.desreport.util.r;
import org.jeecg.modules.jmreport.desreport.util.t;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.a;
import org.jeecg.modules.jmreport.dyndb.util.b;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.jeecgframework.minidao.pojo.MiniDaoPage;
import org.jeecgframework.minidao.util.MiniDaoUtil;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.multipart.MultipartFile;

@Service(value="jmReportDbServiceImpl")
public class k
implements IJmReportDbService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(k.class);
    private static final Pattern b = Pattern.compile("[\u4e00-\u9fa5]+");
    @Autowired
    private IJmReportDbParamService jmReportParamService;
    @Autowired
    private IJmReportDbFieldService reportDbFieldService;
    @Autowired
    private IJmReportDbSourceService jmReportDbSourceService;
    @Autowired
    private a jmreportDynamicDbUtil;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JimuReportDbDao reportDbDao;
    @Autowired
    private JimuReportDbParamDao dbParamDao;
    @Autowired
    private IJimuReportService jimuReportService;
    @Lazy
    @Autowired(required=false)
    private IJmreportNoSqlService jmreportNoSqlService;
    @Autowired
    private JimuReportDataSourceDao jimuReportDataSourceDao;
    @Value(value="${jeecg.jmreport.apiBasePath:}")
    private String apiBasePath;
    @Autowired
    private JmReportBaseConfig reportBaseConfig;
    @Autowired
    JimuFileUploadHandler jimuFileUploadHandler;
    @Autowired
    private JmReportUploadConfig jmReportUploadConfig;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JmReportDb saveDb(JmReportDb reportDb) {
        if (String.valueOf(1).equals(reportDb.getIsPage())) {
            List<JmReportDb> jmReportDbList = this.reportDbDao.selectList(reportDb.getJimuReportId());
            jmReportDbList.forEach(item -> {
                item.setIsPage("0");
                if (OkConvertUtils.isEmpty(item.getDbSource())) {
                    item.setDbSource("");
                }
                this.a((JmReportDb)item);
            });
        }
        if ("0".equals(reportDb.getDbType()) || "5".equals(reportDb.getDbType())) {
            String dbSourceId = reportDb.getDbSource();
            if (OkConvertUtils.isNotEmpty(dbSourceId)) {
                JmReportDataSource dataSource = this.jmReportDbSourceService.getById(dbSourceId);
                if (dataSource != null) {
                    reportDb.setDbSourceType(MiniDaoUtil.getDbType((String)dataSource.getDbUrl()));
                }
                if (OkConvertUtils.isEmpty(reportDb.getDbSourceType())) {
                    JmreportDynamicDataSourceVo dataSourceVo = this.jmReportDbSourceService.getByDbKey(dbSourceId);
                    reportDb.setDbSourceType(dataSourceVo.getDbType());
                }
            } else {
                String dbType = e.getDatabaseType();
                reportDb.setDbSourceType(dbType);
                reportDb.setDbSource("");
            }
        }
        this.a(reportDb);
        if (OkConvertUtils.isNotEmpty(reportDb.getJimuSharedSourceId())) {
            JmReportDb jmReportDb = this.reportDbDao.get(reportDb.getJimuSharedSourceId());
            String dbCode = jmReportDb.getDbCode();
            BeanUtils.copyProperties((Object)jmReportDb, (Object)reportDb);
            reportDb.setDbCode(dbCode);
            return reportDb;
        }
        String reportId = reportDb.getId();
        this.reportDbFieldService.deleteByReportId(reportId);
        List<JmReportDbField> fieldList = reportDb.getFieldList();
        if (i.a(fieldList)) {
            for (JmReportDbField field : fieldList) {
                field.setJimuReportDbId(reportId);
            }
            this.reportDbFieldService.saveOrUpdateBatch(fieldList);
        }
        this.jmReportParamService.deleteByReportId(reportId);
        List<JmReportDbParam> paramList = reportDb.getParamList();
        if (i.a(paramList)) {
            for (JmReportDbParam param : paramList) {
                param.setJimuReportHeadId(reportId);
                if (param.getSearchFlag() != null) continue;
                param.setSearchFlag(0);
            }
            this.jmReportParamService.saveOrUpdateBatch(paramList);
        }
        return reportDb;
    }

    @Override
    public List<List<Map>> fieldTree(String reportId) {
        ArrayList<List<Map>> resultList = new ArrayList<List<Map>>();
        JmReportDb reportDb = new JmReportDb();
        List<JmReportDb> dbList = this.reportDbDao.selectList(reportId);
        if (i.a(dbList)) {
            for (JmReportDb db : dbList) {
                JmReportDb jmReportDb;
                String dbCode = db.getDbCode();
                if ("4".equals(db.getDbType()) && OkConvertUtils.isNotEmpty(db.getJimuSharedSourceId()) && null != (jmReportDb = this.reportDbDao.get(db.getJimuSharedSourceId()))) {
                    BeanUtils.copyProperties((Object)jmReportDb, (Object)db);
                    db.setDbCode(dbCode);
                    db.setIzSharedSource(1);
                }
                ArrayList dbMapList = new ArrayList();
                HashMap<String, Object> dbMap = new HashMap<String, Object>(5);
                dbMap.put("dbId", db.getId());
                dbMap.put("expand", true);
                dbMap.put("title", db.getDbChName());
                dbMap.put("code", db.getDbCode());
                dbMap.put("type", db.getDbType());
                dbMap.put("isList", db.getIsList());
                dbMap.put("izSharedSource", db.getIzSharedSource());
                List<JmReportDbField> fieldList = this.reportDbFieldService.getByDbId(db.getId());
                ArrayList fileMapList = new ArrayList();
                if (i.a(fieldList)) {
                    for (JmReportDbField dbField : fieldList) {
                        HashMap<String, Object> fieldMap = new HashMap<String, Object>(5);
                        fieldMap.put("expand", true);
                        if (dbField.getFieldName().equals(dbField.getFieldText())) {
                            fieldMap.put("title", dbField.getFieldName());
                            fieldMap.put("fieldText", dbField.getFieldName());
                        } else {
                            fieldMap.put("title", dbField.getFieldName());
                            fieldMap.put("fieldText", dbField.getFieldText());
                        }
                        fileMapList.add(fieldMap);
                    }
                }
                dbMap.put("children", fileMapList);
                dbMapList.add(dbMap);
                resultList.add(dbMapList);
            }
        }
        return resultList;
    }

    @Override
    public boolean queryIsPage(String reportId, String dbCode) {
        int n2 = this.reportDbDao.getCountByReportId(reportId, dbCode);
        boolean bol = false;
        if (n2 > 0) {
            bol = true;
        }
        return bol;
    }

    @Override
    public Map<String, Object> executeSelectApi(String api, String method, String token, String apiConvert, String paramArray) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        if (OkConvertUtils.isNotEmpty(paramArray)) {
            api = this.a(paramArray, api);
        }
        if (api.contains("token")) {
            String[] split;
            String tokenUrl = api.substring(api.indexOf("token"), api.length());
            for (String str : split = tokenUrl.split("&")) {
                String[] subArr = str.split("=");
                if (subArr.length <= 1 || !subArr[0].equals("token")) continue;
                subArr[1] = subArr[1].replace("'", "").replace("'", "");
                subArr[1] = subArr[1].replaceAll("\"", "");
                if (!OkConvertUtils.isNotEmpty(subArr[1])) continue;
                token = subArr[1];
            }
        }
        JSONObject result = this.a(api, method, token);
        ArrayList list = new ArrayList();
        if (result != null && !"".equals(result)) {
            JSONArray jsonArray;
            Object json = null;
            String dataJson = new String();
            if (OkConvertUtils.isEmpty(apiConvert)) {
                Object data = result.get((Object)"data");
                if (null != data) {
                    dataJson = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                }
                json = JSONObject.parse((String)dataJson, (Feature[])new Feature[]{Feature.OrderedField});
            } else {
                Object bean = JimuSpringContextUtils.getBean(apiConvert);
                if (bean != null && bean instanceof ApiDataConvertAdapter) {
                    JSONObject object = RegexMatches.e(JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    ApiDataConvertAdapter adapter = (ApiDataConvertAdapter)bean;
                    String data = adapter.getData(object);
                    dataJson = String.valueOf(data);
                    json = JSONObject.parse((String)dataJson, (Feature[])new Feature[]{Feature.OrderedField});
                } else {
                    throw new JimuReportException("api\u8f6c\u6362\u5668\u4e0d\u8bc6\u522b!");
                }
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
            if (json instanceof JSONObject) {
                JSONObject jsonObj = JSON.parseObject((String)dataJson, (Feature[])new Feature[]{Feature.OrderedField});
                for (String s2 : jsonObj.keySet()) {
                    map.put(s2, jsonObj.get((Object)s2));
                }
                list.add(map);
            } else if (json instanceof JSONArray && (jsonArray = (JSONArray)JSONArray.parse((String)dataJson, (Feature[])new Feature[]{Feature.OrderedField})).size() > 0) {
                JSONObject first = jsonArray.getJSONObject(0);
                for (String s3 : first.keySet()) {
                    map.put(s3, first.get((Object)s3));
                }
                list.add(map);
            }
        }
        resultMap.put("records", list);
        return resultMap;
    }

    @Override
    public Map loadDbData(String dbId, String reportId) {
        JmReportDb jmReportDb;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(5);
        JmReportDb reportDb = this.reportDbDao.get(dbId);
        if (reportDb == null) {
            return resultMap;
        }
        if (JmConst.IS_SHARED_SOURCE.equals(reportDb.getIzSharedSource()) && null != (jmReportDb = this.reportDbDao.getDbCodeByReportDbIdAndShareSourceId(reportId, dbId))) {
            reportDb.setId(jmReportDb.getId());
            reportDb.setDbCode(jmReportDb.getDbCode());
            reportDb.setIsPage(jmReportDb.getIsPage());
            reportDb.setJimuSharedSourceId(jmReportDb.getJimuSharedSourceId());
        }
        List<JmReportDbField> fieldList = this.reportDbFieldService.getByDbId(dbId);
        List<JmReportDbParam> paramList = this.jmReportParamService.list(dbId);
        resultMap.put("dbId", reportDb.getId());
        resultMap.put("reportDb", reportDb);
        resultMap.put("fieldList", fieldList);
        resultMap.put("paramList", paramList);
        return resultMap;
    }

    @Override
    public List<JmReportDataSource> initDataSource(String createBy, String tenantId) {
        List<JmReportDataSource> dataSouList = this.jmReportDbSourceService.querySourceList(createBy, tenantId);
        return dataSouList;
    }

    @Override
    public void saveDbSource(JmReportDataSource sysDataSource) {
        this.jmReportDbSourceService.saveOrUpdate(sysDataSource);
    }

    @Override
    public boolean querySourceCode(JmReportDataSource sysDataSource) {
        boolean bol = false;
        Integer count = 0;
        if (OkConvertUtils.isNotEmpty(sysDataSource.getId())) {
            JmReportDataSource jmReportDataSource = this.jmReportDbSourceService.selectById(sysDataSource.getId());
            if (jmReportDataSource.getCode() != null) {
                if (!jmReportDataSource.getCode().equals(sysDataSource.getCode())) {
                    count = this.jmReportDbSourceService.excelQueryCode(sysDataSource.getCode());
                    if (count == 0) {
                        bol = true;
                    }
                } else {
                    bol = true;
                }
            } else {
                count = this.jmReportDbSourceService.excelQueryCode(sysDataSource.getCode());
                if (count == 0) {
                    bol = true;
                }
            }
        } else {
            count = this.jmReportDbSourceService.excelQueryCode(sysDataSource.getCode());
            if (count == 0) {
                bol = true;
            }
        }
        return bol;
    }

    @Override
    public void delDataSource(JmReportDataSource sysDataSource) {
        this.jmReportDbSourceService.removeById(sysDataSource.getId());
    }

    @Override
    public List<Map<String, Object>> qurestechSql(JmReportDb jmReportDb, JSONObject paramObject) {
        String baseSql;
        String callSql;
        if (jmReportDb == null) {
            return null;
        }
        String sql = jmReportDb.getDbDynSql();
        List<JmReportDbParam> list = this.dbParamDao.list(jmReportDb.getId());
        JSONObject jsonObject = new JSONObject();
        for (JmReportDbParam dbParam : list) {
            if (!OkConvertUtils.isNotEmpty(dbParam.getParamValue())) continue;
            jsonObject.put(dbParam.getParamName(), (Object)dbParam.getParamValue());
        }
        String firstGroupField = "";
        String secondGroupField = "";
        String aggregateField = "";
        if (paramObject.containsKey((Object)"chartSetting")) {
            JSONObject chartSettings = paramObject.getJSONObject("chartSetting");
            firstGroupField = chartSettings.getString("axisX");
            secondGroupField = chartSettings.getString("series");
            aggregateField = chartSettings.getString("axisY");
            paramObject.remove((Object)"chartSetting");
        }
        Map<String, JSONObject> dbParams = i.a(jmReportDb, paramObject);
        JSONObject paramJson = dbParams.get("shared_query_param");
        jsonObject.putAll((Map)paramObject);
        HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
        String dbSource = jmReportDb.getDbSource();
        String dbParamType = "jdbc";
        if (OkConvertUtils.isEmpty(dbSource)) {
            dbParamType = "minidao";
        }
        if (OkConvertUtils.isNotEmpty(callSql = i.f(baseSql = this.jimuReportService.getDbSql(jmReportDb, jsonObject, paramJson, new ArrayList<JmExpression>(), "", sqlParamsMap, dbParamType)))) {
            return this.jmreportDynamicDbUtil.c(dbSource, callSql, (Map<String, Object>)sqlParamsMap);
        }
        if (this.jmReportDbSourceService.isNoSql(dbSource)) {
            return this.jmreportNoSqlService.findList(baseSql, dbSource);
        }
        if (this.jmReportDbSourceService.isFileDataSource(dbSource)) {
            List<JmReportDbField> jmReportDbFields = this.reportDbFieldService.queryFieldsByDbcode(jmReportDb.getJimuReportId(), jmReportDb.getDbCode());
            Map<String, String> fieldMapping = new HashMap<String, String>();
            if (OkConvertUtils.isNotEmpty(jmReportDbFields)) {
                fieldMapping = jmReportDbFields.stream().filter(f2 -> !f2.getFieldName().equals(f2.getFieldNamePhysics())).collect(Collectors.toMap(JmReportDbField::getFieldNamePhysics, JmReportDbField::getFieldName));
            }
            if (OkConvertUtils.isNotEmpty(firstGroupField) && OkConvertUtils.isNotEmpty(aggregateField)) {
                Map<String, String> physicsFieldMapping = fieldMapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                firstGroupField = OkConvertUtils.getString(physicsFieldMapping.get(firstGroupField), firstGroupField);
                secondGroupField = OkConvertUtils.getString(physicsFieldMapping.get(secondGroupField), secondGroupField);
                aggregateField = OkConvertUtils.getString(physicsFieldMapping.get(aggregateField), aggregateField);
                baseSql = this.a(baseSql, Arrays.asList(firstGroupField, secondGroupField), aggregateField);
            }
            return this.jmreportNoSqlService.findListByCalcite(dbSource, baseSql, sqlParamsMap, fieldMapping);
        }
        if (OkConvertUtils.isEmpty(jmReportDb.getDbSource())) {
            return this.reportDbDao.selectListBySql(baseSql, sqlParamsMap);
        }
        return this.jmreportDynamicDbUtil.b(jmReportDb.getDbSource(), baseSql, (Map<String, Object>)sqlParamsMap);
    }

    private String a(String baseSql, List<String> groupFields, String aggregateField) {
        if (baseSql == null || baseSql.trim().isEmpty()) {
            return baseSql;
        }
        if (aggregateField == null || aggregateField.trim().isEmpty()) {
            return baseSql;
        }
        StringBuilder selectClause = new StringBuilder();
        if (groupFields != null && !groupFields.isEmpty()) {
            groupFields = groupFields.stream().filter(OkConvertUtils::isNotEmpty).collect(Collectors.toList());
            selectClause.append(String.join((CharSequence)", ", groupFields)).append(", ");
        }
        selectClause.append("SUM(").append(aggregateField).append(") AS ").append(aggregateField);
        StringBuilder aggSql = new StringBuilder("SELECT " + selectClause + " FROM (" + baseSql + ") AS jmAggQuery");
        if (groupFields != null && !groupFields.isEmpty()) {
            String groupByClause = String.join((CharSequence)", ", groupFields);
            aggSql.append(" GROUP BY ").append(groupByClause);
        }
        return aggSql.toString();
    }

    @Override
    public List<Map> parseData(Map<String, Object> map, String api) {
        ArrayList<Map> paramList = new ArrayList<Map>();
        ArrayList recordsArray = (ArrayList)map.get("records");
        JSONObject fieldObject = null;
        if (OkConvertUtils.isNotEmpty(api)) {
            fieldObject = this.b(api);
        }
        if (recordsArray != null && recordsArray.size() >= 1) {
            LinkedHashMap resultMap = (LinkedHashMap)recordsArray.get(0);
            Integer orderNum = 1;
            for (Map.Entry entry : resultMap.entrySet()) {
                String key = (String)entry.getKey();
                LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
                param.put("fieldName", key);
                if (null != fieldObject && fieldObject.containsKey((Object)key)) {
                    param.put("fieldText", fieldObject.get((Object)key));
                } else {
                    param.put("fieldText", key);
                }
                param.put("widgetType", "String");
                param.put("isShow", true);
                Integer n2 = orderNum;
                orderNum = orderNum + 1;
                param.put("orderNum", n2);
                paramList.add(param);
            }
        }
        return paramList;
    }

    @Override
    public List<Map<String, Object>> loadDataSourceTable(String dbKey) {
        List<Map<String, Object>> tableList;
        block3: {
            String dbType;
            block5: {
                JmreportDynamicDataSourceVo dbSource;
                block4: {
                    tableList = null;
                    dbSource = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
                    dbType = MiniDaoUtil.getDbType((String)dbSource.getDbUrl());
                    String tableSql = org.jeecg.modules.jmreport.dyndb.util.b.f(dbSource.getDbUrl());
                    if (!OkConvertUtils.isNotEmpty(tableSql) || !OkConvertUtils.isNotEmpty(dbType)) break block3;
                    tableList = dbType.toLowerCase().contains("clickhouse") || dbSource.getDbUrl().toLowerCase().contains("taos") ? this.jmreportDynamicDbUtil.d(dbKey, tableSql, new HashMap<String, Object>(5)) : this.jmreportDynamicDbUtil.b(dbKey, tableSql, (Map<String, Object>)new HashMap<String, Object>(5));
                    if (!org.jeecg.modules.jmreport.dyndb.util.b.b(dbType) && !dbType.toLowerCase().contains("oscar") && !dbType.toLowerCase().contains("hsqldb") && !dbType.toLowerCase().contains("db2") && !dbType.toLowerCase().contains("h2") && !dbType.toLowerCase().contains("derby") && !dbType.toLowerCase().contains("clickhouse")) break block4;
                    for (Map<String, Object> map : tableList) {
                        map.put("name", OkConvertUtils.isNotEmpty(map.get("NAME")) ? map.get("NAME") : map.get("name"));
                    }
                    break block3;
                }
                if (!dbSource.getDbUrl().toLowerCase().contains("taos")) break block5;
                for (Map<String, Object> map : tableList) {
                    if (!map.containsKey("table_name")) continue;
                    byte[] tableName = (byte[])map.get("table_name");
                    map.put("name", new String(tableName, StandardCharsets.UTF_8));
                }
                break block3;
            }
            if (!org.jeecg.modules.jmreport.dyndb.util.b.a(dbType)) break block3;
            for (Map<String, Object> map : tableList) {
                map.put("name", map.get("Name"));
            }
        }
        return tableList;
    }

    @Override
    public List<Map<String, Object>> loadDsTableFields(String dbKey, String tableName) {
        List<Map<String, Object>> fields = null;
        JmreportDynamicDataSourceVo dbSource = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
        String dbType = MiniDaoUtil.getDbType((String)dbSource.getDbUrl());
        String tableFieldsSql = org.jeecg.modules.jmreport.dyndb.util.b.g(dbSource.getDbUrl());
        if (OkConvertUtils.isNotEmpty(tableFieldsSql) && OkConvertUtils.isNotEmpty(dbType)) {
            HashMap<String, Object> params = new HashMap<String, Object>(5);
            params.put("tableName", tableName);
            params.put("schema", this.jmreportDynamicDbUtil.b(dbKey));
            fields = this.jmreportDynamicDbUtil.b(dbKey, tableFieldsSql, (Map<String, Object>)params);
            if (OkConvertUtils.isNotEmpty(fields)) {
                fields = fields.stream().map(fieldMap -> {
                    HashMap newFieldMap = new HashMap(5);
                    fieldMap.forEach((key, val) -> newFieldMap.put(key.toUpperCase(), val));
                    return newFieldMap;
                }).collect(Collectors.toList());
            }
        }
        return fields;
    }

    @Override
    public Map<String, Object> loadTableData(String dbKey, String tableName, Integer pageNo, Integer pageSize, String sql, String paramArray) {
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        String token = this.jimuTokenClient.getToken();
        Map<String, Object> systemParam = null;
        if (OkConvertUtils.isNotEmpty(token)) {
            systemParam = this.jimuTokenClient.getUserInfo(token);
        }
        HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
        String dbParamType = "jdbc";
        if (OkConvertUtils.isEmpty(dbKey)) {
            dbParamType = "minidao";
        }
        boolean noSql = this.jmReportDbSourceService.isNoSql(dbKey);
        sql = OkConvertUtils.isNotEmpty(paramArray) ? i.a(sql, systemParam, JSONArray.parseArray((String)paramArray), sqlParamsMap, dbParamType, noSql, dbKey) : i.a(sql, systemParam, null, sqlParamsMap, dbParamType, noSql, dbKey);
        a.debug("\u62a5\u8868\u67e5\u8be2querySql=>\r\n" + sql);
        String callSql = i.f(sql);
        if (OkConvertUtils.isNotEmpty(callSql)) {
            List<Map<String, Object>> pageList = this.jmreportDynamicDbUtil.c(dbKey, callSql, (Map<String, Object>)sqlParamsMap);
            result.put("records", i.b(pageList));
        } else if (this.jmReportDbSourceService.isNoSql(dbKey)) {
            List<Map<String, Object>> pageList;
            if (RegexMatches.i(sql)) {
                String pageSql = MiniDaoUtil.createPageSql((String)"jdbc:mysql:", (String)sql, (int)pageNo, (int)pageSize);
                pageList = this.jmreportNoSqlService.findListByCalcite(dbKey, pageSql, sqlParamsMap);
            } else {
                pageList = this.jmreportNoSqlService.findList(sql, dbKey);
            }
            result.put("records", i.b(pageList));
        } else if (this.jmReportDbSourceService.isFileDataSource(dbKey)) {
            String pageSql = MiniDaoUtil.createPageSql((String)"jdbc:mysql:", (String)sql, (int)pageNo, (int)pageSize);
            List<Map<String, Object>> dataList = this.jmreportNoSqlService.findListByCalcite(dbKey, pageSql, sqlParamsMap);
            result.put("records", i.b(dataList));
        } else if (OkConvertUtils.isNotEmpty(dbKey)) {
            JmreportDynamicDataSourceVo dbSource = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
            String pageSql = MiniDaoUtil.createPageSql((String)dbSource.getDbUrl(), (String)sql, (int)pageNo, (int)pageSize);
            a.debug("\u62a5\u8868\u67e5\u8be2pageSQL=>\r\n" + pageSql);
            List<Map<String, Object>> pageList = this.jmreportDynamicDbUtil.b(dbKey, pageSql, (Map<String, Object>)sqlParamsMap);
            result.put("records", i.b(pageList));
        } else {
            MiniDaoPage<Map<String, Object>> mapMiniDaoPage = this.reportDbDao.selectPageBySql(sql, pageNo, pageSize, sqlParamsMap);
            result.put("total", mapMiniDaoPage.getTotal());
            result.put("records", i.b(mapMiniDaoPage.getResults()));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delDbData(String dbId) {
        JmReportDb reportDb = this.getById(dbId);
        this.reportDbDao.deleteById(dbId);
        this.reportDbFieldService.deleteByReportId(dbId);
        this.jmReportParamService.deleteByReportId(dbId);
        if ("6".equals(reportDb.getDbType())) {
            String dbTableFileName = reportDb.getDbTableName();
            this.deleteFilesDsFile(reportDb.getJimuReportId(), dbTableFileName);
        }
    }

    private JSONObject a(String api, String method, String token) {
        a.debug("\u62a5\u8868API \u67e5\u8be2sendHttpRequest \u539f\u59cbAPI=> " + api);
        Map<String, Object> systemParam = this.jimuTokenClient.getUserInfo(token);
        api = i.a(api, systemParam, this.apiBasePath);
        api = i.j(api);
        a.debug("\u62a5\u8868API \u67e5\u8be2sendHttpRequest \u66ff\u6362\u540eAPI=> " + api);
        a.debug("\u62a5\u8868API \u67e5\u8be2sendHttpRequest Method=> " + method);
        if (api.contains("'")) {
            api = api.replace("'", "");
        }
        String result = new String();
        try {
            if ("0".equals(method)) {
                result = i.b(api, token);
            } else {
                JSONObject paramJson = i.g(api);
                result = i.a(api, token, paramJson);
            }
            a.debug("\u62a5\u8868API \u67e5\u8be2sendHttpRequest result=> " + result);
            JSONObject jsonStr = JSONObject.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
            return jsonStr;
        }
        catch (ResourceAccessException e2) {
            a.warn("\u8fde\u63a5\u8d85\u65f6:" + e2.getMessage(), (Throwable)e2);
            throw new JimuReportException("api\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        catch (JimuReportException e3) {
            throw e3;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<String, Object> parseReportSql(String sql, String dbKey, Object paramArray, String type, String[] roles) throws JimuReportException {
        result = new HashMap<String, Object>(5);
        dataList = new ArrayList<E>();
        token = this.jimuTokenClient.getToken();
        systemParam = null;
        if (OkConvertUtils.isNotEmpty(token)) {
            systemParam = this.jimuTokenClient.getUserInfo(token);
        }
        sqlParamsMap = new HashMap<String, Object>();
        dbParamType = "jdbc";
        if (OkConvertUtils.isEmpty(dbKey)) {
            dbParamType = "minidao";
        }
        noSql = this.jmReportDbSourceService.isNoSql(dbKey);
        sql = OkConvertUtils.isNotEmpty(paramArray) != false ? i.a(sql, systemParam, JSONArray.parseArray((String)paramArray.toString()), sqlParamsMap, dbParamType, noSql, dbKey) : i.a(sql, systemParam, null, sqlParamsMap, dbParamType, noSql, dbKey);
        paramList = i.b(sql);
        callSql = i.f(sql);
        if (OkConvertUtils.isNotEmpty(callSql)) {
            dataList = this.jmreportDynamicDbUtil.c(dbKey, callSql, (Map<String, Object>)sqlParamsMap);
            if (OkConvertUtils.isEmpty(dataList)) {
                throw new JimuReportException(1001, "\u6570\u636e\u4e3a\u7a7a");
            }
        } else if (this.jmReportDbSourceService.isNoSql(dbKey)) {
            if (RegexMatches.i(sql)) {
                pageSql = MiniDaoUtil.createPageSql((String)"jdbc:mysql:", (String)sql, (int)1, (int)1);
                dataList = this.jmreportNoSqlService.findListByCalcite(dbKey, pageSql, sqlParamsMap);
            } else {
                try {
                    dataList = this.jmreportNoSqlService.findList(sql, dbKey);
                }
                catch (Exception e) {
                    throw new JimuReportException(1001, e.getMessage());
                }
            }
        } else if (this.jmReportDbSourceService.isFileDataSource(dbKey)) {
            try {
                pageSql = MiniDaoUtil.createPageSql((String)"jdbc:mysql:", (String)sql, (int)1, (int)1);
                dataList = this.jmreportNoSqlService.findListByCalcite(dbKey, pageSql, sqlParamsMap);
            }
            catch (Exception e) {
                k.a(e.getCause(), e);
                try {
                    dataList = t.a(sql);
                }
                catch (Exception exception) {
                    k.a.warn(exception.getMessage());
                    throw new JimuReportException("\u89e3\u6790\u5931\u8d25");
                }
            }
            if (OkConvertUtils.isEmpty(dataList)) {
                dataList = t.a(sql);
            }
        } else {
            dataSourceSafe = this.reportBaseConfig.getFirewall() != null ? this.reportBaseConfig.getFirewall().getDataSourceSafe() : false;
            hasIntersection = e.a(roles, JmConst.ALLOW_DEV_SQL_ROLES);
            enableQueryAll = this.reportBaseConfig.getEnableQueryAll();
            if (enableQueryAll && OkConvertUtils.isEmpty(dbKey)) {
                enableQueryAll = false;
            }
            if (dataSourceSafe && !hasIntersection && !enableQueryAll) {
                selectStarPattern = o.i;
                matcher = selectStarPattern.matcher(sql.toUpperCase());
                if (matcher.find()) {
                    throw new JimuReportException(1001, "\u5b89\u5168\u6a21\u5f0f\u4e0b\u4e0d\u652f\u6301select * \u5f00\u5934\u7684SQL\u8bed\u53e5\u89e3\u6790\uff01");
                }
                dataList = t.a(sql);
            } else if (OkConvertUtils.isEmpty(dbKey)) {
                try {
                    try {
                        mapMiniDaoPage = this.reportDbDao.selectPageBySql(sql, 1, 1, sqlParamsMap);
                        dataList = mapMiniDaoPage.getResults();
                    }
                    catch (Exception e) {
                        k.a(e.getCause(), e);
                        dataList = t.a(sql);
                    }
                    if (!OkConvertUtils.isEmpty(dataList)) ** GOTO lbl112
                    dataList = t.a(sql);
                }
                catch (Exception e) {
                    if (e instanceof JimuReportException) {
                        throw new JimuReportException(1001, "\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
                    }
                    cause = e.getCause();
                    if ("0".equals(type)) {
                        k.a.warn(e.getMessage());
                        result.put("message", "\u89e3\u6790\u5931\u8d25");
                        return result;
                    }
                    if (cause instanceof SQLSyntaxErrorException) {
                        throw new JimuReportException(e.getMessage());
                    }
                    if (e instanceof UncategorizedSQLException) {
                        throw new JimuReportException("SQL\u8bed\u6cd5\u9519\u8bef\uff01");
                    }
                    throw new JimuReportException(e);
                }
            } else {
                dbSource = JmreportDataSourceCachePool.getCacheDynamicDataSourceModel(dbKey);
                pageSql = MiniDaoUtil.createPageSql((String)dbSource.getDbUrl(), (String)sql, (int)1, (int)1);
                try {
                    try {
                        dataList = this.jmreportDynamicDbUtil.b(dbKey, pageSql, (Map<String, Object>)sqlParamsMap);
                    }
                    catch (Exception e) {
                        k.a(e.getCause(), e);
                        try {
                            dataList = t.a(sql);
                        }
                        catch (Exception exception) {
                            k.a.warn(exception.getMessage());
                            throw new JimuReportException("\u89e3\u6790\u5931\u8d25");
                        }
                    }
                    if (OkConvertUtils.isEmpty(dataList)) {
                        dataList = t.a(sql);
                    }
                }
                catch (Exception e) {
                    if (e instanceof JimuReportException) {
                        throw new JimuReportException(1001, "\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
                    }
                    if ("0".equals(type)) {
                        k.a.warn(e.getMessage());
                        result.put("message", "\u89e3\u6790\u5931\u8d25");
                        return result;
                    }
                    if (e.getMessage().contains("bad SQL grammar")) {
                        throw new JimuReportException("SQL\u8bed\u6cd5\u9519\u8bef\uff01");
                    }
                    throw new JimuReportException(e);
                }
            }
        }
lbl112:
        // 8 sources

        if (dataList != null && dataList.size() > 0) {
            fieldList = new ArrayList<LinkedHashMap<K, V>>();
            map = (Map)dataList.get(0);
            orderNum = 1;
            fieldNames = new ArrayList<String>();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                key = ((String)entry.getKey()).toLowerCase();
                param = new LinkedHashMap<String, Object>();
                fieldName = key;
                if (this.jmReportDbSourceService.isFileDataSource(dbKey)) {
                    chineseMatcher = k.b.matcher(key);
                    if (chineseMatcher.find()) {
                        fieldName = k.a(key);
                        i = 1;
                        while (fieldNames.contains(fieldName)) {
                            fieldName = (String)fieldName + i;
                            ++i;
                        }
                        fieldNames.add((String)fieldName);
                    }
                    param.put("fieldNamePhysics", key);
                }
                param.put("fieldName", fieldName);
                param.put("fieldText", key);
                param.put("widgetType", "String");
                param.put("orderNum", orderNum++);
                fieldList.add(param);
            }
            result.put("fieldList", fieldList);
            result.put("paramList", paramList);
        }
        return result;
    }

    private static String a(String content) {
        Matcher matcher = b.matcher(content);
        while (matcher.find()) {
            String matchContent = matcher.group();
            content = matcher.replaceFirst(Pinyin.toPinyin((String)matchContent, (String)"_").toLowerCase());
            matcher = b.matcher(content);
        }
        return content;
    }

    private static void a(Throwable cause, Exception e2) {
        if (cause instanceof SQLSyntaxErrorException) {
            throw new JimuReportException(e2.getMessage());
        }
        if (e2 instanceof UncategorizedSQLException || e2.getMessage().contains("bad SQL grammar")) {
            String detailMsg = k.a(cause);
            throw new JimuReportException("SQL\u8bed\u6cd5\u9519\u8bef\uff01" + detailMsg);
        }
        throw new JimuReportException(e2.getMessage());
    }

    private static String a(Throwable e2) {
        if (e2 instanceof JimuFileDsParseException) {
            return e2.getMessage();
        }
        if (null != e2.getCause()) {
            return k.a(e2.getCause());
        }
        return "";
    }

    private String a(Object paramArray, String api) {
        JSONArray jsonArray = JSONArray.parseArray((String)String.valueOf(paramArray));
        HashMap map = new HashMap(5);
        for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
            JSONObject param = jsonArray.getJSONObject(i2);
            Object paramName = param.get((Object)"paramName");
            Object paramValue = param.get((Object)"paramValue");
            if (OkConvertUtils.isNotEmpty(paramName) && OkConvertUtils.isNotEmpty(paramValue)) {
                api = api.replace("${" + paramName + "}", String.valueOf(paramValue));
                api = api.replace("'${" + paramName + "}'", String.valueOf(paramValue));
            }
            if (!OkConvertUtils.isNotEmpty(paramName) || !OkConvertUtils.isNotEmpty(paramValue)) continue;
            String valueStr = ExpressUtil.a(String.valueOf(paramValue), null);
            api = api.replace(String.valueOf(paramValue), valueStr);
        }
        return api;
    }

    @Override
    public Result addDataSource(JmReportDataSource dataSource, HttpServletRequest request) {
        String userName = this.jimuTokenClient.getUsername(request);
        dataSource.setDbPassword(g.e(dataSource.getDbPassword()));
        dataSource.setConnectTimes(0);
        this.saveDbSource(dataSource);
        JmreportDataSourceCachePool.b(dataSource.getId());
        return Result.OK("\u64cd\u4f5c\u6210\u529f\uff01", true);
    }

    @Override
    public List<Map<String, Object>> queryTableName(String key, String tableName) {
        ArrayList<Map<String, Object>> tableList = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> mapList = this.loadDataSourceTable(key);
        if (OkConvertUtils.isEmpty(tableName)) {
            return mapList;
        }
        Pattern pattern = Pattern.compile(tableName.toLowerCase());
        for (Map<String, Object> map : mapList) {
            Map<Object, Object> newMap = new HashMap(5);
            String name = String.valueOf(map.get("name"));
            Matcher matcher = pattern.matcher(name.toLowerCase());
            if (matcher.find()) {
                newMap = map;
                newMap.put("name", map.get("name"));
            }
            if (newMap.size() <= 0 || null == newMap) continue;
            tableList.add(newMap);
        }
        return tableList;
    }

    @Override
    public void updateById(JmReportDb reportDb) {
        this.reportDbDao.update(reportDb);
    }

    @Override
    public JmReportDb getById(String apiSelectId) {
        return this.reportDbDao.get(apiSelectId);
    }

    @Override
    public int getCount(String reportId, String code) {
        return this.reportDbDao.getCount(reportId, code);
    }

    @Override
    public List<JmReportDb> getListReportDb(String reportId) {
        return this.reportDbDao.selectList(reportId);
    }

    @Override
    public JmPage<JmReportDataSource> getDataSourceByPages(String userName, Integer pageNo, Integer pageSize) {
        JmReportDataSource source = new JmReportDataSource();
        source.setCreateBy(userName);
        source.setWithoutDbType("FILES");
        String tenantId = "";
        if ("tenant".equals(this.reportBaseConfig.getSaasMode())) {
            tenantId = OkConvertUtils.getString(this.jimuTokenClient.getTenantId(), "\u83b7\u53d6\u4e0d\u5230\u79df\u6237ID");
            source.setTenantId(tenantId);
        }
        MiniDaoPage<JmReportDataSource> dataSourceList = this.jimuReportDataSourceDao.getAll(source, pageNo, pageSize);
        JmPage<JmReportDataSource> jmPage = h.a(dataSourceList);
        return jmPage;
    }

    @Override
    public Integer getDbCount() {
        return this.reportDbDao.getDbCount();
    }

    public void a(JmReportDb reportDb) {
        if (OkConvertUtils.isNotEmpty(reportDb.getId())) {
            if (OkConvertUtils.isNotEmpty(reportDb.getJimuSharedSourceId())) {
                JmReportDb db = new JmReportDb();
                db.setIsPage(reportDb.getIsPage());
                db.setId(reportDb.getId());
                this.reportDbDao.update(db);
                return;
            }
            this.reportDbDao.update(reportDb);
        } else {
            reportDb.setId(String.valueOf(SnowflakeIdWorker.generateId()));
            this.reportDbDao.insert(reportDb);
        }
    }

    private JSONObject b(String api) {
        Matcher matcher = org.jeecg.modules.jmreport.common.constant.b.Q.matcher(api);
        if (!matcher.find()) {
            return null;
        }
        JSONObject fieldObject = new JSONObject();
        String url = api.substring(0, api.indexOf("/desform/api/data/"));
        String desformCode = api.replace(url, "").replace("/desform/api/data/", "").replace("/queryById", "");
        if (OkConvertUtils.isNotEmpty(desformCode)) {
            JSONObject jsonObject;
            Object fields;
            JSONObject object;
            Integer code;
            String getFieldsUrl = url + "/desform/api/fields/" + desformCode + "?subTable=true";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("X-Access-Token", this.jimuTokenClient.getToken());
            ResponseEntity<String> responseEntity = r.a(getFieldsUrl, paramMap, String.class, new Object[0]);
            String body = (String)responseEntity.getBody();
            if (OkConvertUtils.isNotEmpty(body) && 200 == (code = (object = JSONObject.parseObject((String)body)).getInteger("code")) && null != (fields = (jsonObject = object.getJSONObject("result")).get((Object)"fields"))) {
                JSONArray filedJson = JSONArray.parseArray((String)fields.toString());
                for (int i2 = 0; i2 < filedJson.size(); ++i2) {
                    String filedText = filedJson.getJSONObject(i2).getString("name");
                    String filedName = filedJson.getJSONObject(i2).getString("model");
                    fieldObject.put(filedName, (Object)filedText);
                }
            }
        }
        return fieldObject;
    }

    @Override
    public JmPage<JmReportDb> getJmReportSharedDbPageList(Integer pageNo, Integer pageSize, String name) {
        if (OkConvertUtils.isNotEmpty(name)) {
            name = "%" + (String)name + "%";
        }
        MiniDaoPage<JmReportDb> pageList = this.reportDbDao.getJmReportSharedDbPageList((String)name, pageNo, pageSize);
        return h.a(pageList);
    }

    @Override
    public void linkJmReportShareDb(JmReportDb jmReportDb) {
        String jimuSharedSourceId;
        String jimuReportId = jmReportDb.getJimuReportId();
        Long count = this.reportDbDao.getCountByReportIdAndDbId(jimuReportId, jimuSharedSourceId = jmReportDb.getJimuSharedSourceId());
        if (count > 0L) {
            throw new JimuReportException("\u5df2\u5b58\u5728\u5171\u4eab\u6570\u636e\u96c6\uff01");
        }
        JmReportDb dbDataByReportDbId = this.reportDbDao.getDbDataByShareReportId(jimuSharedSourceId);
        if (null == dbDataByReportDbId) {
            throw new JimuReportException("\u672a\u627e\u5230\u5171\u4eab\u6570\u636e\u96c6\uff01");
        }
        Object dbCode = dbDataByReportDbId.getDbCode();
        int codeCount = this.reportDbDao.getCount(jimuReportId, (String)dbCode);
        if (codeCount > 0) {
            dbCode = (String)dbCode + org.jeecg.modules.jmreport.common.util.k.getInstance().a(4, 1);
        }
        JmReportDb reportDb = new JmReportDb();
        BeanUtils.copyProperties((Object)dbDataByReportDbId, (Object)reportDb);
        reportDb.setId(SnowflakeIdWorker.generateId().toString());
        reportDb.setDbCode((String)dbCode);
        reportDb.setJimuReportId(jmReportDb.getJimuReportId());
        reportDb.setDbType("4");
        reportDb.setJimuSharedSourceId(jimuSharedSourceId);
        this.reportDbDao.insert(reportDb);
    }

    @Override
    public void unlinkDbByReportIdAndDbId(JmReportDb jmReportDb) {
        String jimuReportId = jmReportDb.getJimuReportId();
        String jimuSharedSourceId = jmReportDb.getJimuSharedSourceId();
        if (OkConvertUtils.isNotEmpty(jimuReportId) && OkConvertUtils.isNotEmpty(jimuSharedSourceId)) {
            this.reportDbDao.unlinkDbByReportIdAndDbId(jimuReportId, jimuSharedSourceId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delShareDbByDbId(JmReportDb jmReportDb) {
        String id = jmReportDb.getId();
        Long count = this.reportDbDao.getCountByReportShareSourceId(id);
        if (count > 0L) {
            throw new JimuReportException("\u8be5\u5171\u4eab\u6570\u636e\u96c6\u4e0b\u5b58\u5728\u62a5\u8868\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.reportDbDao.deleteById(id);
        this.reportDbFieldService.deleteByReportId(id);
        this.jmReportParamService.deleteByReportId(id);
    }

    @Override
    public Result<?> addFilesDsTable(String reportId, MultipartFile multipartFile, boolean isSingle) {
        Result<JmReportDataSource> result;
        block21: {
            result = new Result<JmReportDataSource>();
            File uploadedFile = null;
            try {
                if (OkConvertUtils.isEmpty(multipartFile)) {
                    return Result.error("\u8bf7\u4e0a\u4f20\u6587\u4ef6");
                }
                c.a(multipartFile);
                if (OkConvertUtils.isEmpty(reportId)) {
                    reportId = "shared";
                }
                String bizPath = "filesDataSet" + File.separator + reportId;
                String url = "";
                a.debug("\u6587\u4ef6\u6570\u636e\u6e90\u4e0a\u4f20\u5f00\u59cb");
                url = this.jimuFileUploadHandler.a(multipartFile, bizPath, JimuFileUploadHandler.NamesakeStrategy.b);
                a.debug("\u6587\u4ef6\u6570\u636e\u6e90\u4e0a\u4f20\u5f00\u59cb------------------------------\u8fd4\u56deurl:{}", (Object)url);
                uploadedFile = new File(this.jmReportUploadConfig.getPath().getUpload() + File.separator + url);
                ArrayList<FilesDsTable> currentFileTables = new ArrayList<FilesDsTable>();
                String fileName = FilenameUtils.getName((String)url);
                String fileExt = FilenameUtils.getExtension((String)url);
                Object fileBaseName = FilenameUtils.getBaseName((String)url);
                if ("xls".equals(fileExt) || "xlsx".equals(fileExt)) {
                    try (Workbook wb = WorkbookFactory.create((File)uploadedFile);){
                        for (int i2 = 0; i2 < wb.getNumberOfSheets(); ++i2) {
                            Sheet sheet = wb.getSheetAt(i2);
                            if (OkConvertUtils.isEmpty(sheet)) continue;
                            Object tableName = sheet.getSheetName();
                            if (((String)fileBaseName).contains("_")) {
                                String[] split = ((String)fileBaseName).split("_");
                                tableName = (String)tableName + "_" + split[split.length - 1];
                            } else {
                                tableName = (String)tableName + "_" + (String)fileBaseName;
                            }
                            currentFileTables.add(k.a((String)tableName + "_excel", fileName));
                        }
                    }
                } else {
                    fileBaseName = "json".equals(fileExt) ? (String)fileBaseName + "_json" : (String)fileBaseName + "_csv";
                    currentFileTables.add(k.a((String)fileBaseName, fileName));
                }
                JmReportDataSource jmReportDataSource = this.jimuReportDataSourceDao.getFileDataSource(reportId);
                List<FilesDsTable> filesDsTables = new ArrayList<FilesDsTable>();
                if (null == jmReportDataSource) {
                    jmReportDataSource = new JmReportDataSource();
                } else if (OkConvertUtils.isNotEmpty(jmReportDataSource.getDbUrl())) {
                    filesDsTables = JSONArray.parseArray((String)jmReportDataSource.getDbUrl(), FilesDsTable.class);
                }
                filesDsTables.addAll(currentFileTables);
                jmReportDataSource.setReportId(reportId);
                jmReportDataSource.setDbType("FILES");
                jmReportDataSource.setName(reportId + "\u6587\u4ef6\u6570\u636e\u6e90");
                jmReportDataSource.setDbDriver(bizPath);
                jmReportDataSource.setDbUrl(JSONObject.toJSONString(filesDsTables));
                this.saveDbSource(jmReportDataSource);
                if (OkConvertUtils.isNotEmpty(jmReportDataSource.getId())) {
                    JmreportDataSourceCachePool.b(jmReportDataSource.getId());
                }
                if (isSingle) {
                    jmReportDataSource.setDbUrl(JSONObject.toJSONString(currentFileTables));
                }
                result.setMessage(url);
                result.setSuccess(true);
                result.setResult(jmReportDataSource);
            }
            catch (Exception e2) {
                if (null != uploadedFile) {
                    org.jeecg.modules.jmreport.common.util.i.a(uploadedFile);
                }
                result.setSuccess(false);
                result.setMessage("");
                a.error(e2.getMessage(), (Throwable)e2);
                if (!(e2 instanceof JimuReportException)) break block21;
                throw (JimuReportException)e2;
            }
        }
        return result;
    }

    private static FilesDsTable a(String tableName, String fileName) {
        FilesDsTable table = new FilesDsTable();
        tableName = "jmf." + (String)tableName;
        table.setName((String)tableName);
        table.setFileName(fileName);
        return table;
    }

    @Override
    public Result<?> deleteFilesDsTable(String reportId, String tableName) {
        return this.a(reportId, tableName, true);
    }

    private Result<Object> a(String reportId, String name, boolean byTableName) {
        JmReportDataSource jmReportDataSource;
        String dbUrl;
        if (OkConvertUtils.isEmpty(reportId)) {
            reportId = "shared";
        }
        if (OkConvertUtils.isEmpty(dbUrl = (jmReportDataSource = this.jimuReportDataSourceDao.getFileDataSource(reportId)).getDbUrl()) || !dbUrl.contains(name)) {
            return Result.OK();
        }
        List filesDsTables = JSONArray.parseArray((String)dbUrl, FilesDsTable.class);
        List willDelTables = filesDsTables.stream().filter(Objects::nonNull).filter(filesDsTable -> {
            if (byTableName) {
                return filesDsTable.getName().equals(name);
            }
            return filesDsTable.getFileName().equals(name);
        }).collect(Collectors.toList());
        if (OkConvertUtils.isEmpty(willDelTables)) {
            return Result.OK();
        }
        List<JmReportDb> allDbs = this.reportDbDao.selectList(reportId);
        String allDsSql = "";
        if (OkConvertUtils.isNotEmpty(allDbs)) {
            allDsSql = allDbs.stream().filter(Objects::nonNull).filter(db -> "6".equalsIgnoreCase(db.getDbType()) || "5".equalsIgnoreCase(db.getDbType())).map(JmReportDb::getDbDynSql).collect(Collectors.joining());
        }
        HashMap<String, String> willDelFileNames = new HashMap<String, String>();
        for (FilesDsTable willDelTable : willDelTables) {
            if (allDsSql.contains(willDelTable.getName())) continue;
            filesDsTables.remove(willDelTable);
            willDelFileNames.put(willDelTable.getFileName(), willDelTable.getName());
        }
        if (OkConvertUtils.isEmpty(willDelFileNames)) {
            return Result.error("\u65e0\u6cd5\u5220\u9664" + (byTableName ? "\u6570\u636e\u8868" : "\u6587\u4ef6") + ",\u6b63\u5728\u88ab\u6570\u636e\u96c6\u4f7f\u7528");
        }
        jmReportDataSource.setDbUrl(JSONObject.toJSONString((Object)filesDsTables));
        this.jimuReportDataSourceDao.update(jmReportDataSource);
        filesDsTables.forEach(filesDsTable -> {
            if (null != filesDsTable) {
                willDelFileNames.remove(filesDsTable.getFileName());
            }
        });
        if (OkConvertUtils.isNotEmpty(willDelFileNames)) {
            Object upload = this.jmReportUploadConfig.getPath().getUpload();
            if (!((String)upload).endsWith(File.separator)) {
                upload = (String)upload + File.separator;
            }
            String fileBasePath = jmReportDataSource.getDbDriver();
            for (String willDelFileName : willDelFileNames.keySet()) {
                File[] files = new File((String)upload + fileBasePath).listFiles((dir, fileName) -> fileName.equals(willDelFileName));
                if (files == null) continue;
                for (File file : files) {
                    org.jeecg.modules.jmreport.common.util.i.a(file);
                }
            }
        }
        return Result.OK();
    }

    @Override
    public Result<?> previewFilesDsTable(String reportId, String tableName) {
        JmReportDataSource jmReportDataSource;
        String dbUrl;
        if (OkConvertUtils.isEmpty(reportId)) {
            reportId = "shared";
        }
        if (OkConvertUtils.isEmpty(dbUrl = (jmReportDataSource = this.jimuReportDataSourceDao.getFileDataSource(reportId)).getDbUrl()) || !dbUrl.contains(tableName)) {
            return Result.OK();
        }
        List filesDsTables = JSONArray.parseArray((String)dbUrl, FilesDsTable.class);
        Optional<FilesDsTable> willDelTableOp = filesDsTables.stream().filter(filesDsTable -> null != filesDsTable && filesDsTable.getName().equals(tableName)).findFirst();
        if (!willDelTableOp.isPresent()) {
            return Result.OK();
        }
        FilesDsTable table = willDelTableOp.get();
        String querySql = String.format("select * from %s limit 5", table.getName());
        List<Map<String, Object>> datas = this.jmreportNoSqlService.findListByCalcite(jmReportDataSource.getId(), querySql, new HashMap<String, Object>());
        return Result.OK(datas);
    }

    @Override
    public Result<?> deleteFilesDsFile(String reportId, String fileName) {
        return this.a(reportId, fileName, false);
    }

    @Override
    public Result<?> saveSingleFilesDataset(String id, String reportId, JmreportDynamicDataSourceVo dbSource, String[] roles, String dbChName) {
        JmReportDb reportDb;
        org.jeecg.modules.jmreport.common.util.c.b("\u8bf7\u4e0a\u4f20\u6587\u4ef6", dbSource);
        org.jeecg.modules.jmreport.common.util.c.b("\u53c2\u6570\u5f02\u5e38:\u62a5\u8868id", reportId);
        org.jeecg.modules.jmreport.common.util.c.b("\u53c2\u6570\u5f02\u5e38:\u6570\u636e\u6e90", dbSource.getId());
        JmReportDataSource dataSource = this.jmReportDbSourceService.getById(dbSource.getId());
        org.jeecg.modules.jmreport.common.util.c.b("\u6570\u636e\u6e90\u4e0d\u5b58\u5728", dataSource);
        String dbType = dataSource.getDbType();
        org.jeecg.modules.jmreport.common.util.c.a("\u53ea\u6709\u6587\u4ef6\u6570\u636e\u6e90\u652f\u6301\u5feb\u901f\u521b\u5efa", "FILES", dbType);
        String dbUrl = dbSource.getDbUrl();
        List filesDsTables = JSONArray.parseArray((String)dbUrl, FilesDsTable.class);
        org.jeecg.modules.jmreport.common.util.c.b("\u8bf7\u786e\u4fdd\u6587\u4ef6\u683c\u5f0f\u7b26\u5408\u8981\u6c42", filesDsTables);
        FilesDsTable filesDsTable = (FilesDsTable)filesDsTables.get(0);
        if (OkConvertUtils.isNotEmpty(id)) {
            reportDb = this.reportDbDao.get(id);
            org.jeecg.modules.jmreport.common.util.c.b("\u6570\u636e\u96c6\u4e0d\u5b58\u5728", reportDb);
        } else {
            reportDb = new JmReportDb();
        }
        String sql = String.format("select * from %s", filesDsTable.getName());
        Map<String, Object> map = this.parseReportSql(sql, dbSource.getId(), null, "0", roles);
        List fieldList = (List)map.get("fieldList");
        org.jeecg.modules.jmreport.common.util.c.b("\u89e3\u6790\u5931\u8d25,\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u7b26\u5408\u8981\u6c42", fieldList);
        String baseFileName = FilenameUtils.getBaseName((String)filesDsTable.getFileName());
        Object code = baseFileName;
        if (baseFileName.length() > 4) {
            code = baseFileName.substring(0, 4);
        }
        code = "file_" + k.a((String)code);
        int existsNum = 0;
        do {
            code = (String)code + (Serializable)(existsNum > 0 ? Integer.valueOf(existsNum) : "");
            ++existsNum;
        } while (this.getCount(reportId, (String)code) != 0);
        reportDb.setDbChName(OkConvertUtils.getString(dbChName, baseFileName));
        reportDb.setDbCode((String)code);
        reportDb.setDbDynSql(sql);
        reportDb.setDbSource(dbSource.getId());
        reportDb.setDbTableName(filesDsTable.getFileName());
        reportDb.setFieldList(OkConvertUtils.createFromListMap(fieldList, JmReportDbField.class));
        reportDb.setDbType("6");
        reportDb.setIsList("1");
        reportDb.setIsList("1");
        reportDb.setIzSharedSource(0);
        reportDb.setJimuReportId(reportId);
        this.saveDb(reportDb);
        return Result.OK();
    }

    @Override
    public Result<?> getSingleFilesDataset(String dataSetId) {
        org.jeecg.modules.jmreport.common.util.c.b("\u53c2\u6570\u5f02\u5e38:\u6570\u636e\u96c6id", dataSetId);
        JmReportDb reportDb = this.reportDbDao.get(dataSetId);
        String sourceKey = reportDb.getDbSource();
        JmReportDataSource dataSource = this.jmReportDbSourceService.getById(sourceKey);
        String dbTableFileName = reportDb.getDbTableName();
        String dbChName = reportDb.getDbChName();
        String dbUrl = dataSource.getDbUrl();
        List filesDsTables = JSONArray.parseArray((String)dbUrl, FilesDsTable.class);
        List filteredTables = filesDsTables.stream().filter(Objects::nonNull).filter(dsTable -> dsTable.getFileName().equalsIgnoreCase(dbTableFileName)).collect(Collectors.toList());
        dataSource.setDbUrl(JSONObject.toJSONString(filteredTables));
        dataSource.setDbChName(dbChName);
        return Result.OK(dataSource);
    }
}

