/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.desreport.service.a;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.OkConvertUtils;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.dao.JimuReportDataSourceDao;
import org.jeecg.modules.jmreport.desreport.entity.JmReportDataSource;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.jeecg.modules.jmreport.dyndb.JmreportDataSourceCachePool;
import org.jeecg.modules.jmreport.dyndb.util.LocalCache;
import org.jeecg.modules.jmreport.dyndb.util.b;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.jeecgframework.minidao.util.MiniDaoUtil;
import org.jeecgframework.minidao.util.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jmReportDbSourceServiceImpl")
public class l
implements IJmReportDbSourceService {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(l.class);
    @Autowired
    private JimuReportDataSourceDao dataSourceDao;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private LocalCache localCache;
    @Autowired
    private DataSource dataSource;

    @Override
    public JmReportDataSource selectById(String id) {
        return this.dataSourceDao.get(id);
    }

    @Override
    public Integer excelQueryCode(String dbKey) {
        return this.dataSourceDao.excelQueryId(dbKey);
    }

    @Override
    public List<JmReportDataSource> querySourceList(String createBy, String tenantId) {
        return this.dataSourceDao.selectListByUser(createBy, tenantId, "FILES");
    }

    @Override
    public boolean isNoSql(String dbKey) {
        JmreportDynamicDataSourceVo dataSourceVo = this.getByDbKey(dbKey);
        String dbType = dataSourceVo.getDbType();
        return this.isHave(JmConst.NO_SQL, dbType);
    }

    @Override
    public boolean isFileDataSource(String dbKey) {
        JmreportDynamicDataSourceVo dataSourceVo = this.getByDbKey(dbKey);
        String dbType = dataSourceVo.getDbType();
        return "FILES".equals(dbType);
    }

    @Override
    public boolean isHave(String[] strs, String dbType) {
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!OkConvertUtils.isNotEmpty(dbType) || !dbType.contains(strs[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public JmreportDynamicDataSourceVo getByDbKey(String dbKey) {
        JmReportDataSource dbSource = this.dataSourceDao.get(dbKey);
        return new JmreportDynamicDataSourceVo(dbSource);
    }

    @Override
    public JmReportDataSource getById(String dbSourceId) {
        return this.dataSourceDao.get(dbSourceId);
    }

    @Override
    public void saveOrUpdate(JmReportDataSource sysDataSource) {
        if (OkConvertUtils.isNotEmpty(sysDataSource.getId())) {
            this.dataSourceDao.update(sysDataSource);
        } else {
            sysDataSource.setId(String.valueOf(SnowflakeIdWorker.generateId()));
            sysDataSource.setType("report");
            this.dataSourceDao.insert(sysDataSource);
        }
    }

    @Override
    public void removeById(String id) {
        this.dataSourceDao.deleteById(id);
    }

    @Override
    public void updateConnectTimes(String id, Integer connectTimes) {
        this.dataSourceDao.updateConnectTimes(id, connectTimes);
        JmreportDataSourceCachePool.b(id);
    }

    @Override
    public String getDbKey(String dbKey, String username) {
        return this.dataSourceDao.getDbKey(dbKey, username);
    }

    @Override
    public synchronized void verifyConnectNumber() {
        boolean dataSourceSafe;
        boolean bl = dataSourceSafe = this.jmBaseConfig.getFirewall() != null ? this.jmBaseConfig.getFirewall().getDataSourceSafe() : false;
        if (dataSourceSafe) {
            Object key = "";
            Object count = null;
            if ("created".equals(this.jmBaseConfig.getSaasMode())) {
                String username = this.jimuTokenClient.getUsername();
                key = "datasource_test_" + username;
                count = this.localCache.a((String)key);
            } else if ("tenant".equals(this.jmBaseConfig.getSaasMode())) {
                String tenantId = this.jimuTokenClient.getTenantId();
                key = "datasource_test_" + tenantId;
                count = this.localCache.a((String)key);
            }
            if (null != count && Integer.parseInt(count.toString()) >= 10) {
                throw new JimuReportException("\u3010\u5f00\u542f\u6570\u636e\u6e90\u5b89\u5168\u3011\u4e00\u5929\u5185\u8fde\u63a5\u6d4b\u8bd5\u6b21\u6570\u6700\u591a10\u6b21\uff0c\u8bf7\u660e\u5929\u518d\u8bd5\uff01");
            }
            long time = 86400000L;
            if (null == count) {
                this.localCache.a((String)key, 1, time);
            } else {
                int conCount = Integer.parseInt(count.toString()) + 1;
                this.localCache.a((String)key, conCount, time);
            }
        }
    }

    @Override
    public Integer getCount() {
        return this.dataSourceDao.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTableNum() throws SQLException {
        int tableNum = 0;
        try (Connection connection = this.dataSource.getConnection();){
            List<Map<String, Object>> tableList;
            DatabaseMetaData md = connection.getMetaData();
            String url = md.getURL();
            String allTableSql = b.f(url);
            if (OkConvertUtils.isNotEmpty(allTableSql) && (tableList = this.dataSourceDao.getAllTable(allTableSql)) != null && tableList.size() > 0) {
                tableNum = tableList.size();
            }
        }
        return tableNum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> getAllTable() {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            String url = md.getURL();
            String allTableSql = b.f(url);
            if (!OkConvertUtils.isNotEmpty(allTableSql)) return Collections.emptyList();
            List<Map<String, Object>> list = this.dataSourceDao.getAllTable(allTableSql);
            return list;
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Map<String, Object>> getTableFields(String tableName) {
        List<Map<String, Object>> fields = null;
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData md = connection.getMetaData();
            String url = md.getURL();
            String dbType = MiniDaoUtil.getDbType((String)url);
            String tableFieldsSql = b.g(url);
            if (OkConvertUtils.isEmpty(tableFieldsSql)) {
                List<Map<String, Object>> list = Collections.emptyList();
                return list;
            }
            tableFieldsSql.replace(":tableName", tableName);
            tableFieldsSql.replace(":schema", connection.getCatalog());
            fields = this.dataSourceDao.getAllTable(tableFieldsSql);
            if (!OkConvertUtils.isNotEmpty(fields)) return fields;
            fields = fields.stream().map(fieldMap -> {
                HashMap newFieldMap = new HashMap(5);
                fieldMap.forEach((key, val) -> newFieldMap.put(key.toUpperCase(), val));
                return newFieldMap;
            }).collect(Collectors.toList());
            return fields;
        }
        catch (Exception e2) {
            a.error(e2.getMessage(), (Throwable)e2);
        }
        return fields;
    }
}

