/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.RedisBusyException;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisClusterDownException;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PingConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PingConnectionHandler.class);
    private final RedisClientConfig config;

    public PingConnectionHandler(RedisClientConfig config) {
        this.config = config;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Object connection = RedisConnection.getFrom(ctx.channel());
        ((RedisConnection)connection).getConnectionPromise().whenComplete((res, e) -> {
            if (e == null) {
                this.sendPing(ctx);
            }
        });
        ctx.fireChannelActive();
    }

    private void sendPing(ChannelHandlerContext ctx) {
        Object connection = RedisConnection.getFrom(ctx.channel());
        CommandData<?, ?> currentCommand = ((RedisConnection)connection).getCurrentCommand();
        RFuture future = ((RedisConnection)connection).getUsage() == 0 && (currentCommand == null || !currentCommand.isBlockingCommand()) ? ((RedisConnection)connection).async(StringCodec.INSTANCE, RedisCommands.PING, new Object[0]) : null;
        this.config.getTimer().newTimeout(timeout -> {
            if (connection.isClosed() || ctx.isRemoved()) {
                return;
            }
            CommandData<?, ?> cd = connection.getCurrentCommand();
            if (cd != null && cd.isBlockingCommand()) {
                this.sendPing(ctx);
                return;
            }
            if (connection.getUsage() == 0 && future != null && (future.cancel(false) || this.cause(future) != null)) {
                Throwable cause = this.cause(future);
                if (!(cause instanceof RedisLoadingException || cause instanceof RedisTryAgainException || cause instanceof RedisClusterDownException || cause instanceof RedisBusyException)) {
                    if (!future.isCancelled()) {
                        log.error("Unable to send PING command over channel: " + ctx.channel(), cause);
                    }
                    log.debug("channel: {} closed due to PING response timeout set in {} ms", (Object)ctx.channel(), (Object)this.config.getPingConnectionInterval());
                    ctx.channel().close();
                    connection.getRedisClient().trySetupFirstFail();
                } else {
                    connection.getRedisClient().resetFirstFail();
                    this.sendPing(ctx);
                }
            } else {
                connection.getRedisClient().resetFirstFail();
                this.sendPing(ctx);
            }
        }, (long)this.config.getPingConnectionInterval(), TimeUnit.MILLISECONDS);
    }

    protected Throwable cause(RFuture<?> future) {
        try {
            future.toCompletableFuture().getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }
}

