/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.h2.parser;

import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.dialect.h2.parser.H2Lexer;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.util.Arrays;

public class H2ExprParser
extends SQLExprParser {
    private static final String[] AGGREGATE_FUNCTIONS;
    private static final long[] AGGREGATE_FUNCTIONS_CODES;

    public H2ExprParser(String sql) {
        this(new H2Lexer(sql));
        this.lexer.nextToken();
    }

    public H2ExprParser(String sql, SQLParserFeature ... features) {
        this(new H2Lexer(sql, features));
        this.lexer.nextToken();
    }

    public H2ExprParser(Lexer lexer) {
        super(lexer);
        this.dbType = lexer.getDbType();
        this.aggregateFunctions = AGGREGATE_FUNCTIONS;
        this.aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;
    }

    @Override
    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        column = super.parseColumnRest(column);
        if (this.lexer.identifierEquals(FnvHash.Constants.GENERATED)) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.BY) {
                this.lexer.nextToken();
                this.accept(Token.DEFAULT);
                column.setGeneratedAlwaysAs(new SQLDefaultExpr());
            } else {
                this.acceptIdentifier("ALWAYS");
                column.setGeneratedAlwaysAs(new SQLIdentifierExpr("ALWAYS"));
            }
            this.accept(Token.AS);
            this.acceptIdentifier("IDENTITY");
            SQLColumnDefinition.Identity identity = new SQLColumnDefinition.Identity();
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                SQLIntegerExpr seed = (SQLIntegerExpr)this.primary();
                this.accept(Token.COMMA);
                SQLIntegerExpr increment = (SQLIntegerExpr)this.primary();
                this.accept(Token.RPAREN);
                identity.setSeed((Integer)seed.getNumber());
                identity.setIncrement((Integer)increment.getNumber());
            }
            column.setIdentity(identity);
        }
        return column;
    }

    protected SQLColumnDefinition.Identity parseIdentity0() {
        SQLColumnDefinition.Identity identity = new SQLColumnDefinition.Identity();
        this.accept(Token.IDENTITY);
        if (this.lexer.token() == Token.LPAREN) {
            this.accept(Token.LPAREN);
            if (this.lexer.identifierEquals(FnvHash.Constants.START)) {
                this.lexer.nextToken();
                this.accept(Token.WITH);
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                identity.setSeed((Integer)this.lexer.integerValue());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.INCREMENT)) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                identity.setIncrement((Integer)this.lexer.integerValue());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.CYCLE)) {
                this.lexer.nextToken();
                identity.setCycle(true);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MINVALUE)) {
                this.lexer.nextTokenValue();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                identity.setMinValue((Integer)this.lexer.integerValue());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                }
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.MAXVALUE)) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.LITERAL_INT) {
                    throw new ParserException("TODO " + this.lexer.info());
                }
                identity.setMaxValue((Integer)this.lexer.integerValue());
                this.lexer.nextToken();
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                }
            }
            this.accept(Token.RPAREN);
        }
        return identity;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM", "ROW_NUMBER", "ROWNUMBER"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            H2ExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

