/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.paramcheck;

import com.alibaba.nacos.common.paramcheck.AbstractParamChecker;
import com.alibaba.nacos.common.paramcheck.DefaultParamChecker;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParamCheckerManager {
    private static final ParamCheckerManager INSTANCE = new ParamCheckerManager();
    private static final AbstractParamChecker DEFAULT_PARAM_CHECKER = new DefaultParamChecker();
    private final Map<String, AbstractParamChecker> paramCheckerMap = new ConcurrentHashMap<String, AbstractParamChecker>();

    private ParamCheckerManager() {
        Collection<AbstractParamChecker> paramCheckers = NacosServiceLoader.load(AbstractParamChecker.class);
        for (AbstractParamChecker paramChecker : paramCheckers) {
            String checkerType = paramChecker.getCheckerType();
            this.paramCheckerMap.put(checkerType, paramChecker);
        }
    }

    public static ParamCheckerManager getInstance() {
        return INSTANCE;
    }

    public AbstractParamChecker getParamChecker(String checkerType) {
        if (StringUtils.isBlank(checkerType)) {
            return DEFAULT_PARAM_CHECKER;
        }
        AbstractParamChecker paramChecker = this.paramCheckerMap.get(checkerType);
        if (paramChecker == null) {
            paramChecker = DEFAULT_PARAM_CHECKER;
        }
        return paramChecker;
    }
}

