/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.examples.rds;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.rds.RdsClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class RdsUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readJson(String file, Class<T> clazz) {
        URL resource = clazz.getClassLoader().getResource(file);
        if (resource == null) return null;
        try (InputStream inputStream = resource.openStream();){
            Object object = new ObjectMapper().readValue(inputStream, clazz);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read JSON from file: " + file, e);
        }
    }

    public static RdsClient createRdsClient() {
        String endPoint = "rds.bj.baidubce.com";
        String accessKey = "ak";
        String secretAccessKy = "sk";
        BceClientConfiguration config = new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretAccessKy)).withEndpoint(endPoint);
        RdsClient rdsClient = new RdsClient(config);
        return rdsClient;
    }
}

