/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.grpc;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.grpc.NettyChannelFactoryImpl;
import com.clickhouse.client.grpc.OkHttpChannelFactoryImpl;
import com.clickhouse.client.grpc.config.ClickHouseGrpcOption;
import com.clickhouse.client.grpc.impl.ClickHouseGrpc;
import com.clickhouse.client.internal.google.gson.Gson;
import com.clickhouse.client.internal.google.gson.stream.JsonReader;
import com.clickhouse.client.internal.grpc.ManagedChannel;
import com.clickhouse.client.internal.grpc.ManagedChannelBuilder;
import com.clickhouse.client.internal.grpc.Status;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ClickHouseGrpcChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseGrpcChannelFactory.class);
    private static final String PROP_NAME = "name";
    private static final String PROP_SERVICE = "service";
    private static final String PROP_METHOD = "method";
    private static final String PROP_METHOD_CONFIG = "methodConfig";
    private static final String PROP_RETRY_POLICY = "retryPolicy";
    private static final String PROP_MAX_ATTEMPTS = "maxAttempts";
    private static final String serviceName = "clickhouse.grpc.ClickHouse";
    private static final String methodName = ClickHouseGrpc.getExecuteQueryWithStreamIOMethod().getBareMethodName();
    private static final Map<String, ?> defaultServiceConfig;
    protected final ClickHouseConfig config;
    protected final ClickHouseNode server;

    public static ClickHouseGrpcChannelFactory getFactory(ClickHouseConfig config, ClickHouseNode server) {
        return (Boolean)config.getOption(ClickHouseGrpcOption.USE_OKHTTP) != false ? new OkHttpChannelFactoryImpl(config, server) : new NettyChannelFactoryImpl(config, server);
    }

    protected ClickHouseGrpcChannelFactory(ClickHouseConfig config, ClickHouseNode server) {
        this.config = ClickHouseChecker.nonNull(config, "config");
        this.server = ClickHouseChecker.nonNull(server, "server");
    }

    protected Map<String, ?> getDefaultServiceConfig() {
        Map config = defaultServiceConfig;
        try {
            config = (Map)new Gson().fromJson(new JsonReader(new InputStreamReader(ClickHouseUtils.getFileInputStream("grpc-config.json"), StandardCharsets.UTF_8)), (Type)((Object)Map.class));
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"Use default service config due to: %s", e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)"Failed to load service config", e);
        }
        return config;
    }

    protected abstract ManagedChannelBuilder<?> getChannelBuilder();

    protected void setupRetry() {
        ManagedChannelBuilder<?> builder = this.getChannelBuilder();
        if (this.config.isRetry()) {
            Map<String, ?> serviceConfig = this.getDefaultServiceConfig();
            int maxAttempts = -1;
            Object value = serviceConfig.get(PROP_METHOD_CONFIG);
            if (value instanceof List) {
                for (Object o : (List)value) {
                    Map m;
                    if (!(o instanceof Map)) continue;
                    Map methodConfig = (Map)o;
                    value = methodConfig.get(PROP_NAME);
                    boolean matched = value instanceof List;
                    if (matched) {
                        matched = false;
                        for (Object n : (List)value) {
                            Map m2;
                            Object v;
                            if (!(n instanceof Map) || (v = (m2 = (Map)n).get(PROP_SERVICE)) != null && !serviceName.equals(v) || (v = m2.get(PROP_METHOD)) != null && !methodName.equals(v)) continue;
                            matched = true;
                            break;
                        }
                    }
                    if (!matched || !((value = methodConfig.get(PROP_RETRY_POLICY)) instanceof Map) || !((value = (m = (Map)value).get(PROP_MAX_ATTEMPTS)) instanceof Number)) continue;
                    maxAttempts = ((Number)value).intValue();
                }
            }
            ((ManagedChannelBuilder)builder.defaultServiceConfig(serviceConfig)).enableRetry();
            if (maxAttempts > 0) {
                builder.maxRetryAttempts(maxAttempts);
            }
        } else {
            builder.disableRetry();
        }
    }

    protected abstract void setupSsl();

    protected abstract void setupTimeout();

    protected void setupMisc() {
        ManagedChannelBuilder<?> builder = this.getChannelBuilder();
        if (((Boolean)this.config.getOption(ClickHouseGrpcOption.USE_FULL_STREAM_DECOMPRESSION)).booleanValue()) {
            builder.enableFullStreamDecompression();
        }
        ((ManagedChannelBuilder)builder.maxInboundMessageSize((Integer)this.config.getOption(ClickHouseGrpcOption.MAX_INBOUND_MESSAGE_SIZE))).maxInboundMetadataSize((Integer)this.config.getOption(ClickHouseGrpcOption.MAX_INBOUND_METADATA_SIZE));
    }

    public ManagedChannel create() {
        log.debug((Object)"Establishing channel to [%s]", this.server);
        this.setupRetry();
        this.setupSsl();
        this.setupMisc();
        ManagedChannel c = this.getChannelBuilder().build();
        log.debug((Object)"Channel established: %s", c);
        return c;
    }

    static {
        HashMap<String, String> name = new HashMap<String, String>();
        name.put(PROP_SERVICE, serviceName);
        name.put(PROP_METHOD, methodName);
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        retryPolicy.put(PROP_MAX_ATTEMPTS, 5.0);
        retryPolicy.put("initialBackoff", "0.5s");
        retryPolicy.put("maxBackoff", "30s");
        retryPolicy.put("backoffMultiplier", 2.0);
        retryPolicy.put("retryableStatusCodes", Collections.singletonList(Status.UNAVAILABLE.getCode().name()));
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put(PROP_NAME, Collections.singletonList(name));
        methodConfig.put(PROP_RETRY_POLICY, retryPolicy);
        HashMap config = new HashMap();
        config.put(PROP_METHOD_CONFIG, Collections.singletonList(methodConfig));
        defaultServiceConfig = Collections.unmodifiableMap(config);
    }
}

