/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.auth.scope;

import com.coze.openapi.client.auth.scope.ScopeAccountPermission;
import com.coze.openapi.client.auth.scope.ScopeAttributeConstraint;
import com.coze.openapi.client.auth.scope.ScopeAttributeConstraintConnectorBotChatAttribute;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Scope {
    @JsonProperty(value="account_permission")
    private ScopeAccountPermission accountPermission;
    @JsonProperty(value="attribute_constraint")
    private ScopeAttributeConstraint attributeConstraint;

    public Map<String, Object> toMap() {
        ObjectMapper mapper = new ObjectMapper();
        return (Map)mapper.convertValue((Object)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static Scope buildBotChat(List<String> botIDList, List<String> permissionList) {
        if (permissionList == null || permissionList.isEmpty()) {
            permissionList = Collections.singletonList("Connector.botChat");
        }
        ScopeAttributeConstraint attributeConstraint = null;
        if (botIDList != null && !botIDList.isEmpty()) {
            ScopeAttributeConstraintConnectorBotChatAttribute chatAttribute = new ScopeAttributeConstraintConnectorBotChatAttribute(botIDList);
            attributeConstraint = new ScopeAttributeConstraint(chatAttribute);
        }
        return new Scope(new ScopeAccountPermission(permissionList), attributeConstraint);
    }

    public ScopeAccountPermission getAccountPermission() {
        return this.accountPermission;
    }

    public ScopeAttributeConstraint getAttributeConstraint() {
        return this.attributeConstraint;
    }

    @JsonProperty(value="account_permission")
    public void setAccountPermission(ScopeAccountPermission accountPermission) {
        this.accountPermission = accountPermission;
    }

    @JsonProperty(value="attribute_constraint")
    public void setAttributeConstraint(ScopeAttributeConstraint attributeConstraint) {
        this.attributeConstraint = attributeConstraint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScopeAccountPermission this$accountPermission = this.getAccountPermission();
        ScopeAccountPermission other$accountPermission = other.getAccountPermission();
        if (this$accountPermission == null ? other$accountPermission != null : !((Object)this$accountPermission).equals(other$accountPermission)) {
            return false;
        }
        ScopeAttributeConstraint this$attributeConstraint = this.getAttributeConstraint();
        ScopeAttributeConstraint other$attributeConstraint = other.getAttributeConstraint();
        return !(this$attributeConstraint == null ? other$attributeConstraint != null : !((Object)this$attributeConstraint).equals(other$attributeConstraint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Scope;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScopeAccountPermission $accountPermission = this.getAccountPermission();
        result = result * 59 + ($accountPermission == null ? 43 : ((Object)$accountPermission).hashCode());
        ScopeAttributeConstraint $attributeConstraint = this.getAttributeConstraint();
        result = result * 59 + ($attributeConstraint == null ? 43 : ((Object)$attributeConstraint).hashCode());
        return result;
    }

    public String toString() {
        return "Scope(accountPermission=" + this.getAccountPermission() + ", attributeConstraint=" + this.getAttributeConstraint() + ")";
    }

    public Scope(ScopeAccountPermission accountPermission, ScopeAttributeConstraint attributeConstraint) {
        this.accountPermission = accountPermission;
        this.attributeConstraint = attributeConstraint;
    }
}

