/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.file;

import com.coze.openapi.api.FileAPI;
import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.files.RetrieveFileReq;
import com.coze.openapi.client.files.RetrieveFileResp;
import com.coze.openapi.client.files.UploadFileReq;
import com.coze.openapi.client.files.UploadFileResp;
import com.coze.openapi.client.files.model.FileInfo;
import com.coze.openapi.service.utils.Utils;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class FileService {
    private final FileAPI api;

    public FileService(FileAPI api) {
        this.api = api;
    }

    public UploadFileResp upload(UploadFileReq req) {
        if (req.getFilePath() != null) {
            File file = new File(req.getFilePath());
            return this.uploadFile(file, file.getName(), req);
        }
        if (req.getFileBytes() != null) {
            return this.uploadFile(req.getFileBytes(), req.getFileName(), req);
        }
        if (req.getFile() != null) {
            return this.uploadFile(req.getFile(), req.getFileName(), req);
        }
        throw new IllegalArgumentException("file source is required");
    }

    private UploadFileResp uploadFile(Object fileSource, String filename, BaseReq req) {
        RequestBody requestFile;
        MediaType mediaType;
        if (fileSource instanceof File) {
            mediaType = MediaType.parse((String)"multipart/form-data");
            requestFile = RequestBody.create((MediaType)mediaType, (File)((File)fileSource));
        } else {
            mediaType = MediaType.parse((String)"multipart/form-data");
            requestFile = RequestBody.create((MediaType)mediaType, (byte[])((byte[])fileSource));
        }
        MultipartBody.Part body = MultipartBody.Part.createFormData((String)"file", (String)filename, (RequestBody)requestFile);
        BaseResponse<FileInfo> resp = Utils.execute(this.api.upload(body, req));
        return ((UploadFileResp.UploadFileRespBuilder)((BaseResp.BaseRespBuilder)UploadFileResp.builder().fileInfo(resp.getData())).logID(resp.getLogID())).build();
    }

    public RetrieveFileResp retrieve(RetrieveFileReq req) {
        BaseResponse<FileInfo> resp = Utils.execute(this.api.retrieve(req.getFileID(), req));
        return ((RetrieveFileResp.RetrieveFileRespBuilder)((BaseResp.BaseRespBuilder)RetrieveFileResp.builder().fileInfo(resp.getData())).logID(resp.getLogID())).build();
    }
}

