/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.websocket.common;

import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.websocket.common.BaseEvent;
import com.coze.openapi.service.service.common.CozeLoggerFactory;
import com.coze.openapi.service.service.websocket.common.BaseCallbackHandler;
import com.coze.openapi.service.service.websocket.common.BaseWebsocketsListener;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;

public abstract class BaseWebsocketsClient {
    protected final ObjectMapper objectMapper = Utils.getMapper();
    protected static final Logger logger = CozeLoggerFactory.getLogger();
    protected final WebSocket ws;
    protected final ExecutorService executorService;
    protected static final int CLOSE_TIMEOUT_SECONDS = 10;
    protected final BaseWebsocketsListener listener;

    protected BaseWebsocketsClient(OkHttpClient client, String url, BaseCallbackHandler handler, BaseReq req) {
        Request request = new Request.Builder().url(url).build();
        this.executorService = Executors.newSingleThreadExecutor();
        this.listener = new BaseWebsocketsListener(this::handleEvent, handler, this);
        OkHttpClient.Builder builder = client.newBuilder();
        boolean hasSetTimeout = false;
        if (req != null) {
            if (req.getConnectTimeout() != null) {
                hasSetTimeout = true;
                builder.connectTimeout((long)req.getConnectTimeout().intValue(), TimeUnit.SECONDS);
            }
            if (req.getReadTimeout() != null) {
                hasSetTimeout = true;
                builder.readTimeout((long)req.getReadTimeout().intValue(), TimeUnit.SECONDS);
            }
            if (req.getWriteTimeout() != null) {
                hasSetTimeout = true;
                builder.writeTimeout((long)req.getWriteTimeout().intValue(), TimeUnit.SECONDS);
            }
        }
        this.ws = hasSetTimeout ? builder.build().newWebSocket(request, (WebSocketListener)this.listener) : client.newWebSocket(request, (WebSocketListener)this.listener);
    }

    protected void sendEvent(BaseEvent event) {
        this.ws.send(Utils.toJson(event));
    }

    protected abstract void handleEvent(WebSocket var1, String var2);

    protected abstract BaseCallbackHandler getCallbackHandler();

    protected String parseEventType(JsonNode jsonNode, String text) {
        JsonNode eventTypeNode = jsonNode.get("event_type");
        if (eventTypeNode == null) {
            logger.error("Missing event_type field in event: {}", (Object)text);
            this.getCallbackHandler().onClientException(this, new RuntimeException("Missing event_type field in event"));
            return null;
        }
        return eventTypeNode.asText();
    }

    public void close() {
        try {
            this.ws.close(1000, "Normal closure");
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    System.err.println("ExecutorService did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.executorService.shutdownNow();
        }
        finally {
            this.listener.shutdown();
        }
    }
}

