#!/usr/local/bin/perl5
# regression tests against OpenSSL

#use Expect;
use FileHandle;
use IPC::Open2;

$PIPECT=0;

sub openssl_execute_client {
  local($opensslkeyfile)=@_;
  $client_err="";
  $command="$OPENSSL_PATH/openssl s_client $OPENSSL_GLOBAL_FLAGS -cert $opensslkeyfile  2>&1";
  &debug("Executing OpenSSL client as $command");

  $pid=open2(SUBIN,SUBOUT,"$command");
  
  print SUBOUT <<FOO;
GET / HTTP/1.0
User-Agent: EKR-o-matic

FOO
  
  while(<SUBIN>){
    print "OpenSSL Client says $_\n" if $VERBOSE;

    next if(/verify error/);
    
    if(/error/){
      print;
      $client_err.=$_;
    }
  }  
  $client_err;
}


sub openssl_execute_server { 
  local($opensslkeyfile,$client_auth)=@_;
  
  $clientauth=$client_auth?"-verify 10":"";

  $server_err="";
  $command="$OPENSSL_PATH/openssl s_server -www $clientauth -cert $opensslkeyfile";
  &debug("Executing OpenSSL server as: $command");

  $server_pid=open2(SERVIN,SERVOUT,"$command");
}

sub openssl_cleanup_server {
  #be totally sure
  &debug("Killing $server_pid");
  kill(9,$server_pid);

  local($sout)="";
  while(<SERVIN>){
    print "OpenSSL Server says $_\n" if $VERBOSE;
    
    if(/error/){
      print;
      $sout.=$_;
    }
  }

  $sout;
}


sub exec_sub {
  local($command)=@_;

  local($ih,$oh);
  $PIPECT++;
  

  pipe(P2CR,P2CW)||die("Couldn't create pipe");
  pipe(C2PR,C2PW)||die("Couldn't create pipe");
  
  if($pid = fork){
    print "FORKED PID $pid\n";
    local($oldfd)= select(PARENTWRITE);
    $|=1;
    select($oldfd);
    close(P2CR);
    close(C2PW);
    return(C2PR,P2CW,$pid);
  }
  else{
    close(P2CW);
    close(C2PR);
    open(STDOUT,">&C2PW");
    open(STDERR,">&STDOUT");
    open(STDIN,"<&P2CR");
    $oldfd=select(C2PW);
    $|=1;
    select($oldfd);

    system($command);

    exit(0);
  }
}
1; # require fodder
