/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.OutputStream;
import java.sql.SQLException;

public class DmdbOutputStream
extends OutputStream {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    private DmdbBlob ia;
    private DmdbClob ib;
    private int hr;
    private long ic = 0L;

    public DmdbOutputStream(Object object, long l2) {
        if (object instanceof DmdbBlob) {
            this.ia = (DmdbBlob)object;
            this.hr = 0;
        } else if (object instanceof DmdbClob) {
            this.ib = (DmdbClob)object;
            this.hr = 1;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
        this.ic = l2;
    }

    @Override
    public void write(int n2) {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0) {
            DBError.throwIOException("off IndexOutOfBounds :" + n2);
        }
        if (n3 < 0) {
            DBError.throwIOException("len IndexOutOfBounds :" + n3);
        }
        if (n2 + n3 > byArray.length) {
            DBError.throwIOException("off + len IndexOutOfBounds :" + n2 + n3);
        }
        try {
            if (this.hr == 0) {
                this.ia.do_setBytes(this.ic, byArray, n2, n3);
                this.ic += (long)n3;
            } else if (this.hr == 1) {
                char[] cArray = new char[n3];
                int n4 = 0;
                while (n4 < n3) {
                    cArray[n4] = (char)byArray[n4 + n2];
                    ++n4;
                }
                String string = new String(cArray);
                this.ib.do_setString(this.ic, string);
                this.ic += (long)string.length();
            } else {
                DBError.throwIOException("Fatal error occured in DmdbOutputStream ");
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
    }
}

