/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.DateUtil;
import java.sql.Timestamp;
import java.util.Date;

public class DmDateFormat {
    public static final char YEAR = 'Y';
    public static final char MONTH = 'M';
    public static final char DAY = 'D';
    public static final char AM = 'A';
    public static final char HOUR24 = 'H';
    public static final char HOUR12 = 'h';
    public static final char MINUTE = 'm';
    public static final char SECOND = 'S';
    public static final char MILLISECOND = 's';
    public static final char TIMEZONE_HOUR = 'Z';
    public static final char TIMEZONE_MINUTE = 'z';
    private String pattern;
    private char[] patternChars;
    private StringBuilder sf = new StringBuilder(64);
    private static ThreadLocal formats = new ThreadLocal();

    private static DmDateFormat getFormat() {
        DmDateFormat dmDateFormat = (DmDateFormat)formats.get();
        if (dmDateFormat == null) {
            dmDateFormat = new DmDateFormat();
            formats.set(dmDateFormat);
        }
        return dmDateFormat;
    }

    public static String format(Date date, String string) {
        DmDateFormat dmDateFormat = DmDateFormat.getFormat();
        dmDateFormat.applyPattern(string);
        String string2 = dmDateFormat.format(DateUtil.toDT(date.getTime(), null));
        return string2;
    }

    public static Date parse(String string, String string2) {
        DmDateFormat dmDateFormat = DmDateFormat.getFormat();
        dmDateFormat.applyPattern(string2);
        int[] nArray = dmDateFormat.parse(string);
        return new Date(DateUtil.toTimeInMillis(nArray));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void applyPattern(String string) {
        this.pattern = string.trim();
        this.patternChars = this.pattern.toCharArray();
    }

    private void clear() {
        this.sf.delete(0, this.sf.length());
    }

    public String format(int[] nArray) {
        try {
            this.clear();
            boolean bl = nArray[3] > 12;
            int n2 = 0;
            while (n2 < this.patternChars.length) {
                int n3 = 1;
                while (n2 + n3 < this.patternChars.length && this.patternChars[n2 + n3] == this.patternChars[n2]) {
                    ++n3;
                }
                switch (this.patternChars[n2]) {
                    case 'Y': {
                        this.append(nArray[0], n3);
                        break;
                    }
                    case 'M': {
                        this.append(nArray[1], n3);
                        break;
                    }
                    case 'D': {
                        this.append(nArray[2], n3);
                        break;
                    }
                    case 'A': {
                        this.append(bl ? "PM" : "AM");
                        break;
                    }
                    case 'H': {
                        this.append(nArray[3], n3);
                        break;
                    }
                    case 'h': {
                        if (bl) {
                            this.append(nArray[3] - 12, n3);
                            bl = true;
                            break;
                        }
                        this.append(nArray[3], n3);
                        bl = false;
                        break;
                    }
                    case 'm': {
                        this.append(nArray[4], n3);
                        break;
                    }
                    case 'S': {
                        this.append(nArray[5], n3);
                        break;
                    }
                    case 's': {
                        this.append(this.formatMilliSecond(nArray[6], n3));
                        break;
                    }
                    case 'Z': {
                        if (nArray[7] == Integer.MIN_VALUE) break;
                        int n4 = Math.abs(nArray[7] / 60);
                        if (nArray[7] < 0) {
                            this.append("-");
                        }
                        this.append(n4, n3);
                        break;
                    }
                    case 'z': {
                        if (nArray[7] == Integer.MIN_VALUE) break;
                        int n4 = Math.abs(nArray[7] % 60);
                        this.append(n4, n3);
                        break;
                    }
                    default: {
                        int n4 = 0;
                        while (n4 < n3) {
                            this.append(this.patternChars[n2]);
                            ++n4;
                        }
                        break block1;
                    }
                }
                n2 += n3;
            }
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
        }
        return this.sf.toString();
    }

    public int[] parse(String string) {
        int[] nArray = new int[8];
        nArray[7] = Integer.MIN_VALUE;
        try {
            char[] cArray = string.trim().toCharArray();
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.patternChars.length && n2 < cArray.length) {
                int n4 = 1;
                while (n3 + n4 < this.patternChars.length && this.patternChars[n3 + n4] == this.patternChars[n3]) {
                    ++n4;
                }
                switch (this.patternChars[n3]) {
                    case ' ': {
                        while (n2 < cArray.length && cArray[n2] == ' ') {
                            ++n2;
                        }
                        break;
                    }
                    case 'Y': {
                        nArray[0] = Integer.parseInt(new String(cArray, n2, n4));
                        n2 += n4;
                        break;
                    }
                    case 'M': {
                        nArray[1] = Integer.parseInt(new String(cArray, n2, n4));
                        if (nArray[1] > 12 || nArray[1] < 1) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        n2 += n4;
                        break;
                    }
                    case 'D': {
                        nArray[2] = Integer.parseInt(new String(cArray, n2, n4));
                        n2 += n4;
                        break;
                    }
                    case 'A': {
                        int n5 = 1;
                        while (n2 + n5 < cArray.length && cArray[n2 + n5] != ' ') {
                            ++n5;
                        }
                        String string2 = new String(cArray, n2, n5).toLowerCase();
                        if ("pm".equalsIgnoreCase(string2)) {
                            bl = true;
                        }
                        n2 += n5;
                        break;
                    }
                    case 'H': {
                        nArray[3] = Integer.parseInt(new String(cArray, n2, n4));
                        if (nArray[3] > 24 || nArray[3] < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        n2 += n4;
                        break;
                    }
                    case 'h': {
                        nArray[3] = Integer.parseInt(new String(cArray, n2, n4));
                        if (nArray[3] > 12 || nArray[3] < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        n2 += n4;
                        break;
                    }
                    case 'm': {
                        nArray[4] = Integer.parseInt(new String(cArray, n2, n4));
                        if (nArray[4] > 60 || nArray[4] < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        n2 += n4;
                        break;
                    }
                    case 'S': {
                        nArray[5] = Integer.parseInt(new String(cArray, n2, n4));
                        if (nArray[5] > 60 || nArray[5] < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        n2 += n4;
                        break;
                    }
                    case 's': {
                        int n5 = 1;
                        while (n2 + n5 < cArray.length && cArray[n2 + n5] != ' ') {
                            ++n5;
                        }
                        nArray[6] = Integer.parseInt(new String(cArray, n2, n5));
                        nArray[6] = n5 < 6 ? nArray[6] * (int)Math.pow(10.0, 6 - n5) : nArray[6] / (int)Math.pow(10.0, n5 - 6);
                        n2 += n5;
                        break;
                    }
                    case 'Z': {
                        int n5 = 1;
                        while (n2 + n5 < cArray.length && cArray[n2 + n5] != ' ') {
                            ++n5;
                        }
                        String string2 = new String(cArray, n2, n5).toLowerCase();
                        boolean bl2 = false;
                        if (string2.startsWith("-")) {
                            bl2 = true;
                        }
                        if (string2.startsWith("-") || string2.startsWith("+")) {
                            string2 = string2.substring(1).trim();
                        }
                        String[] stringArray = string2.split(":");
                        short s2 = 0;
                        int n6 = 0;
                        switch (stringArray.length) {
                            case 2: {
                                s2 = Short.parseShort(stringArray[0].trim());
                                n6 = Short.parseShort(stringArray[1].trim());
                                break;
                            }
                            case 1: {
                                s2 = Short.parseShort(stringArray[0].trim());
                                break;
                            }
                            default: {
                                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                            }
                        }
                        int n7 = s2 * 60 + n6;
                        if (n7 < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        nArray[7] = bl2 ? -1 * n7 : n7;
                        n2 += n5;
                        break;
                    }
                    case 'z': {
                        int n5 = 1;
                        while (n2 + n5 < cArray.length && cArray[n2 + n5] != ' ') {
                            ++n5;
                        }
                        String string2 = new String(cArray, n2, n5).toLowerCase();
                        boolean bl2 = false;
                        if (string2.startsWith("-")) {
                            bl2 = true;
                        }
                        if (string2.startsWith("-") || string2.startsWith("+")) {
                            string2 = string2.substring(1).trim();
                        }
                        String[] stringArray = string2.split(":");
                        short s2 = 0;
                        int n6 = 0;
                        switch (stringArray.length) {
                            case 2: {
                                s2 = Short.parseShort(stringArray[0].trim());
                                n6 = Short.parseShort(stringArray[1].trim());
                                break;
                            }
                            case 1: {
                                s2 = Short.parseShort(stringArray[0].trim());
                                break;
                            }
                            default: {
                                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                            }
                        }
                        int n7 = (short)(s2 * 60 + n6);
                        if (n7 < 0) {
                            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                        }
                        nArray[7] = bl2 ? -1 * n7 : n7;
                        n2 += n5;
                        break;
                    }
                    default: {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (this.patternChars[n3 + n5] != cArray[n2 + n5]) {
                                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
                                break;
                            }
                            ++n5;
                        }
                        n2 += n4;
                    }
                }
                n3 += n4;
            }
            if (nArray[2] > 0 && !this.checkDay(nArray[0], nArray[1], nArray[2])) {
                DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason);
            }
            if (bl) {
                nArray[3] = nArray[3] + 12;
            }
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_INVALID_DATETIME_FORMAT.reason, exception);
        }
        return nArray;
    }

    private boolean checkDay(int n2, int n3, int n4) {
        switch (n3) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                if (n4 <= 31 && n4 >= 1) break;
                return false;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                if (n4 <= 30 && n4 >= 1) break;
                return false;
            }
            case 2: {
                boolean bl = this.dmdt_is_leap_year(n2);
                if (bl && (n4 > 29 || n4 < 1)) {
                    return false;
                }
                if (bl || n4 <= 28 && n4 >= 1) break;
                return false;
            }
        }
        return true;
    }

    private boolean dmdt_is_leap_year(int n2) {
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 % 4 == 0) {
            return n2 % 100 != 0 || n2 % 400 == 0;
        }
        return false;
    }

    private String formatMilliSecond(int n2, int n3) {
        String string = null;
        string = n2 < 10 ? "00000" + n2 : (n2 < 100 ? "0000" + n2 : (n2 < 1000 ? "000" + n2 : (n2 < 10000 ? "00" + n2 : (n2 < 100000 ? "0" + n2 : Integer.toString(n2)))));
        if (n3 < 6) {
            string = string.substring(0, n3);
        }
        return string;
    }

    private void append(int n2, int n3) {
        int n4 = (int)Math.pow(10.0, n3);
        if (n2 >= n4) {
            n2 %= n4;
        }
        this.sf.append(String.valueOf(n2 += n4).substring(1));
    }

    private void append(String string) {
        this.sf.append(string);
    }

    private void append(char c2) {
        this.sf.append(c2);
    }

    public static void main(String[] stringArray) {
        DmDateFormat dmDateFormat = new DmDateFormat();
        dmDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss.S");
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        System.out.println(timestamp.toString());
        int[] nArray = dmDateFormat.parse(timestamp.toString());
        System.out.println(nArray);
        dmDateFormat.applyPattern("dd-MM-yyyy hh:mm:ss.SSSSSS a X");
        System.out.println(dmDateFormat.format(nArray));
    }
}

