/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service.impl.category;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.service.ITreeService;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.dataset.dao.CategoryDao;
import com.gccloud.dataset.dto.CategorySearchDTO;
import com.gccloud.dataset.entity.CategoryEntity;
import com.gccloud.dataset.service.ICategoryService;
import com.gccloud.dataset.vo.CategoryVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CategoryServiceImpl
extends ServiceImpl<CategoryDao, CategoryEntity>
implements ICategoryService {
    private static final String SUPER_PARENT_ID = "0";
    private static final String ID_SPLIT = ",";
    @Resource
    private ITreeService treeService;

    @Override
    public List<CategoryVO> getTree(CategorySearchDTO searchDTO) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getType()), CategoryEntity::getType, (Object)searchDTO.getType());
        List list = this.list((Wrapper)wrapper);
        List voList = BeanConvertUtils.convert((List)list, CategoryVO.class);
        this.treeService.transToTree(voList);
        voList.removeIf(categoryVO -> !SUPER_PARENT_ID.equals(categoryVO.getParentId()));
        return voList;
    }

    @Override
    public List<String> getAllChildrenId(String id) {
        CategoryEntity category = (CategoryEntity)((Object)this.getById((Serializable)((Object)id)));
        String ids = category.getIds() + ID_SPLIT;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        wrapper.likeRight(CategoryEntity::getIds, (Object)ids);
        List list = this.list((Wrapper)wrapper);
        return list.stream().map(SuperEntity::getId).collect(Collectors.toList());
    }

    @Override
    public String add(CategoryEntity entity) {
        boolean repeat = this.checkNameRepeat(entity);
        if (repeat) {
            throw new GlobalException("\u8282\u70b9\u540d\u79f0\u91cd\u590d");
        }
        if (StringUtils.isBlank((CharSequence)entity.getParentId())) {
            entity.setParentId(SUPER_PARENT_ID);
        }
        this.save((Object)entity);
        entity.setIds(entity.getId());
        if (!SUPER_PARENT_ID.equals(entity.getParentId())) {
            CategoryEntity parent = (CategoryEntity)((Object)this.getById((Serializable)((Object)entity.getParentId())));
            if (parent == null) {
                throw new GlobalException("\u7236\u8282\u70b9\u4e0d\u5b58\u5728");
            }
            entity.setIds(parent.getIds() + ID_SPLIT + entity.getId());
        }
        this.updateById((Object)entity);
        return entity.getId();
    }

    @Override
    public void update(CategoryEntity entity) {
        boolean repeat = this.checkNameRepeat(entity);
        if (repeat) {
            throw new GlobalException("\u8282\u70b9\u540d\u79f0\u91cd\u590d");
        }
        this.updateById((Object)entity);
    }

    @Override
    public void delete(String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(CategoryEntity::getParentId, (Object)id);
        if (this.list((Wrapper)queryWrapper).size() > 0) {
            throw new GlobalException("\u8be5\u8282\u70b9\u4e0b\u5b58\u5728\u5b50\u8282\u70b9\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public boolean checkNameRepeat(CategoryEntity entity) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(CategoryEntity::getName, (Object)entity.getName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)entity.getType()), CategoryEntity::getType, (Object)entity.getType());
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)entity.getId()), SuperEntity::getId, (Object)entity.getId());
        if (StringUtils.isBlank((CharSequence)entity.getParentId())) {
            queryWrapper.eq(CategoryEntity::getParentId, (Object)SUPER_PARENT_ID);
        } else {
            queryWrapper.eq(CategoryEntity::getParentId, (Object)entity.getParentId());
        }
        return this.list((Wrapper)queryWrapper).size() > 0;
    }
}

