/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class TypeUtilities {
    public static final int BIT_DISPLAY_SIZE = 1;
    public static final int DOUBLE_FLOAT_DISPLAY_SIZE = 24;
    public static final int REAL_DISPLAY_SIZE = 14;
    public static final int BIGINT_DISPLAY_SIZE = 20;
    public static final int GUID_DISPLAY_SIZE = 36;
    public static final int UINT_DISPLAY_SIZE = 10;
    public static final int SINT_DISPLAY_SIZE = 11;
    public static final int USMALLINT_DISPLAY_SIZE = 5;
    public static final int SSMALLINT_DISPLAY_SIZE = 6;
    public static final int UTINYINT_DISPLAY_SIZE = 3;
    public static final int STINYINT_DISPLAY_SIZE = 4;
    public static final int DATE_DISPLAY_SIZE = 10;
    public static final int TIME_NO_FRAC_PREC_DISPLAY_SIZE = 8;
    public static final int TIME_WITH_FRAC_PREC_DISPLAY_SIZE = 9;
    public static final int TIMESTAMP_NO_FRAC_PREC_DISPLAY_SIZE = 19;
    public static final int TIMESTAMP_WITH_FRAC_PREC_DISPLAY_SIZE = 20;
    public static final int BIT_COLUMN_SIZE = 1;
    public static final int DATE_COLUMN_SIZE = 10;
    public static final int DOUBLE_FLOAT_COLUMN_SIZE = 15;
    public static final int GUID_COLUMN_SIZE = 36;
    public static final int INTEGER_COLUMN_SIZE = 10;
    public static final int REAL_COLUMN_SIZE = 7;
    public static final int SMALLINT_COLUMN_SIZE = 5;
    public static final int TINYINT_COLUMN_SIZE = 3;
    public static final int SBIGINT_COLUMN_SIZE = 19;
    public static final int UBIGINT_COLUMN_SIZE = 20;
    public static final int INTERVAL_YEAR_COLUMN_SIZE = 2;
    public static final int INTERVAL_YEAR_TO_MONTH_COLUMN_SIZE = 5;
    public static final int INTERVAL_MONTH_COLUMN_SIZE = 2;
    public static final int INTERVAL_DAY_COLUMN_SIZE = 2;
    public static final int INTERVAL_DAY_TO_HOUR_COLUMN_SIZE = 5;
    public static final int INTERVAL_DAY_TO_MINUTE_COLUMN_SIZE = 8;
    public static final int INTERVAL_DAY_TO_SECOND_COLUMN_SIZE = 18;
    public static final int INTERVAL_HOUR_COLUMN_SIZE = 2;
    public static final int INTERVAL_HOUR_TO_MINUTE_COLUMN_SIZE = 5;
    public static final int INTERVAL_HOUR_TO_SECOND_COLUMN_SIZE = 15;
    public static final int INTERVAL_MINUTE_COLUMN_SIZE = 2;
    public static final int INTERVAL_MINUTE_TO_SECOND_COLUMN_SIZE = 12;
    public static final int INTERVAL_SECOND_COLUMN_SIZE = 9;
    private static final Map<String, Integer> s_stringToSQLTypeMap = TypeUtilities.initializeStringToSQLTypeMap();
    private static final Set<Integer> s_supportedSqlTypes = TypeUtilities.initializeSupportedSqlTypes();
    private static final int NUMPREC_NA = 0;
    private static final int NUMPREC_BITS = 2;
    private static final int NUMPREC_EXACT = 10;
    private static final int DATE_ODBC2 = 9;
    private static final int TIME_ODBC2 = 10;
    private static final int TIMESTAMP_ODBC2 = 11;

    public static long getColumnSize(TypeMetadata typeMetadata, long columnLength) throws ErrorException {
        switch (typeMetadata.getType()) {
            case 2000: 
            case 2002: 
            case 2003: {
                return -4L;
            }
            case -10: 
            case -9: 
            case -8: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                return columnLength;
            }
            case 92: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return 8L;
                }
                return 9 + fracPrecision;
            }
            case 91: {
                return 10L;
            }
            case 93: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return 19L;
                }
                return 20 + fracPrecision;
            }
            case 2: 
            case 3: {
                return typeMetadata.getPrecision();
            }
            case 7: {
                return 7L;
            }
            case 6: 
            case 8: {
                return 15L;
            }
            case -11: {
                return 36L;
            }
            case -7: 
            case 16: {
                return 1L;
            }
            case -5: {
                if (typeMetadata.isSigned()) {
                    return 19L;
                }
                return 20L;
            }
            case 4: {
                return 10L;
            }
            case 5: {
                return 5L;
            }
            case -6: {
                return 3L;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return typeMetadata.getIntervalPrecision();
            }
            case 106: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision();
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 1;
            }
            case 107: 
            case 108: 
            case 111: {
                return typeMetadata.getIntervalPrecision() + 3;
            }
            case 109: {
                return typeMetadata.getIntervalPrecision() + 6;
            }
            case 110: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 9;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 10;
            }
            case 112: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 6;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 7;
            }
            case 113: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 3;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 4;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), new String[]{typeMetadata.getTypeName(), Short.toString(typeMetadata.getType())}, ExceptionType.DATA);
    }

    public static int getSizeInBytes(int type) {
        switch (type) {
            case 2000: 
            case 2002: 
            case 2003: {
                return 0;
            }
            case 92: {
                return 6;
            }
            case 91: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 40;
            }
            case 7: {
                return 4;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case -11: {
                return 16;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -5: {
                return 8;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case -6: {
                return 1;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 34;
            }
        }
        assert (false);
        return 0;
    }

    public static long getDisplaySize(TypeMetadata typeMetadata, long columnSize) throws ErrorException {
        switch (typeMetadata.getType()) {
            case 2000: 
            case 2002: 
            case 2003: {
                return -4L;
            }
            case -4: 
            case -3: 
            case -2: {
                return columnSize * 2L;
            }
            case -7: 
            case 16: {
                return 1L;
            }
            case -5: {
                return 20L;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                return columnSize;
            }
            case -11: {
                return 36L;
            }
            case 2: 
            case 3: {
                short scale = typeMetadata.getScale();
                short precision = typeMetadata.getPrecision();
                if (precision == scale) {
                    return precision + 3;
                }
                if (0 == scale) {
                    return precision + 1;
                }
                return precision + 2;
            }
            case 6: 
            case 8: {
                return 24L;
            }
            case 4: {
                if (!typeMetadata.isSigned()) {
                    return 10L;
                }
                return 11L;
            }
            case 7: {
                return 14L;
            }
            case 5: {
                if (!typeMetadata.isSigned()) {
                    return 5L;
                }
                return 6L;
            }
            case -6: {
                if (!typeMetadata.isSigned()) {
                    return 3L;
                }
                return 4L;
            }
            case 91: {
                return 10L;
            }
            case 92: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return 8L;
                }
                return 9 + fracPrecision;
            }
            case 93: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return 19L;
                }
                return 20 + fracPrecision;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return typeMetadata.getIntervalPrecision() + 1;
            }
            case 107: 
            case 108: 
            case 111: {
                return typeMetadata.getIntervalPrecision() + 4;
            }
            case 109: {
                return typeMetadata.getIntervalPrecision() + 7;
            }
            case 110: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 10;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 11;
            }
            case 112: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 7;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 8;
            }
            case 113: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 4;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 5;
            }
            case 106: {
                short fracPrecision = typeMetadata.getPrecision();
                if (0 == fracPrecision) {
                    return typeMetadata.getIntervalPrecision() + 1;
                }
                return typeMetadata.getIntervalPrecision() + fracPrecision + 2;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED.name(), new String[]{typeMetadata.getTypeName(), Short.toString(typeMetadata.getType())}, ExceptionType.DATA);
    }

    private static Map<String, Integer> initializeStringToSQLTypeMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("SQL_CHAR", 1);
        map.put("SQL_VARCHAR", 12);
        map.put("SQL_LONGVARCHAR", -1);
        map.put("SQL_BINARY", -2);
        map.put("SQL_VARBINARY", -3);
        map.put("SQL_LONGVARBINARY", -4);
        map.put("SQL_BIT", -7);
        map.put("SQL_BOOLEAN", 16);
        map.put("SQL_TINYINT", -6);
        map.put("SQL_SMALLINT", 5);
        map.put("SQL_INTEGER", 4);
        map.put("SQL_BIGINT", -5);
        map.put("SQL_DECIMAL", 3);
        map.put("SQL_NUMERIC", 2);
        map.put("SQL_FLOAT", 6);
        map.put("SQL_DOUBLE", 8);
        map.put("SQL_REAL", 7);
        map.put("SQL_GUID", -11);
        map.put("SQL_TYPE_DATE", 91);
        map.put("SQL_TYPE_TIME", 92);
        map.put("SQL_TYPE_TIMESTAMP", 93);
        map.put("SQL_DATE", 91);
        map.put("SQL_TIME", 92);
        map.put("SQL_TIMESTAMP", 93);
        map.put("SQL_WCHAR", -8);
        map.put("SQL_WVARCHAR", -9);
        map.put("SQL_WLONGVARCHAR", -10);
        map.put("NULL", 0);
        map.put("SQL_INTERVAL_MONTH", 102);
        map.put("SQL_INTERVAL_YEAR", 101);
        map.put("SQL_INTERVAL_YEAR_TO_MONTH", 107);
        map.put("SQL_INTERVAL_DAY", 103);
        map.put("SQL_INTERVAL_DAY_TO_HOUR", 108);
        map.put("SQL_INTERVAL_DAY_TO_MINUTE", 109);
        map.put("SQL_INTERVAL_DAY_TO_SECOND", 110);
        map.put("SQL_INTERVAL_HOUR", 104);
        map.put("SQL_INTERVAL_HOUR_TO_MINUTE", 111);
        map.put("SQL_INTERVAL_HOUR_TO_SECOND", 112);
        map.put("SQL_INTERVAL_MINUTE", 105);
        map.put("SQL_INTERVAL_MINUTE_TO_SECOND", 113);
        map.put("SQL_INTERVAL_SECOND", 106);
        map.put("CHARACTER", 1);
        map.put("CHAR", 1);
        map.put("CHARACTER VARYING", 12);
        map.put("CHAR VARYING", 12);
        map.put("VARCHAR", 12);
        map.put("BIT", -7);
        map.put("NUMERIC", 2);
        map.put("DECIMAL", 3);
        map.put("DEC", 3);
        map.put("INTEGER", 4);
        map.put("INT", 4);
        map.put("SMALLINT", 5);
        map.put("DATE", 91);
        map.put("TIME", 92);
        map.put("TIMESTAMP", 93);
        map.put("FLOAT", 6);
        map.put("REAL", 7);
        map.put("DOUBLE", 8);
        map.put("DOUBLE PRECISION", 8);
        map.put("INTERVAL DAY", 103);
        map.put("INTERVAL DAY TO HOUR", 108);
        map.put("INTERVAL DAY TO MINUTE", 109);
        map.put("INTERVAL_DAY TO SECOND", 110);
        map.put("INTERVAL HOUR", 104);
        map.put("INTERVAL HOUR TO MINUTE", 111);
        map.put("INTERVAL_HOUR TO SECOND", 112);
        map.put("INTERVAL MINUTE", 105);
        map.put("INTERVAL MINUTE TO SECOND", 113);
        map.put("INTERVAL MONTH", 102);
        map.put("INTERVAL SECOND", 106);
        map.put("INTERVAL YEAR", 101);
        map.put("INTERVAL YEAR TO MONTH", 107);
        map.put("SQL_ARRAY", 2003);
        map.put("SQL_STRUCT", 2002);
        map.put("JAVA_OBJECT", 2000);
        return Collections.unmodifiableMap(map);
    }

    private static Set<Integer> initializeSupportedSqlTypes() {
        return Collections.unmodifiableSet(new HashSet<Integer>(s_stringToSQLTypeMap.values()));
    }

    public static short getIntervalCodeFromConciseType(int conciseType) {
        switch (conciseType) {
            case 91: {
                return 1;
            }
            case 92: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case 103: {
                return 3;
            }
            case 108: {
                return 8;
            }
            case 109: {
                return 9;
            }
            case 110: {
                return 10;
            }
            case 104: {
                return 4;
            }
            case 111: {
                return 11;
            }
            case 112: {
                return 12;
            }
            case 105: {
                return 5;
            }
            case 113: {
                return 13;
            }
            case 102: {
                return 2;
            }
            case 106: {
                return 6;
            }
            case 101: {
                return 1;
            }
            case 107: {
                return 7;
            }
        }
        return 0;
    }

    public static Set<Integer> getSupportedSqlTypes() {
        return s_supportedSqlTypes;
    }

    public static int getVerboseTypeFromConciseType(int conciseType) {
        switch (conciseType) {
            case 91: 
            case 92: 
            case 93: {
                return 9;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return 10;
            }
        }
        return conciseType;
    }

    public static boolean isApproximateNumericType(int type) {
        return type == 7 || type == 6 || type == 8;
    }

    public static boolean isBinaryType(int type) {
        return type == -2 || type == -3 || type == -4;
    }

    public static boolean isBooleanType(int type) {
        return type == -7 || type == 16;
    }

    public static boolean isCharacterOrBinaryType(int type) {
        return TypeUtilities.isBinaryType(type) || TypeUtilities.isCharacterType(type);
    }

    public static boolean isCharacterType(int type) {
        return type == 12 || type == 1 || type == -8 || type == -9 || type == -1 || type == -10;
    }

    public static boolean isDateTimeType(int type) {
        return type == 91 || type == 92 || type == 93;
    }

    public static boolean isExactNumericType(int type) {
        return type == 2 || type == 3;
    }

    public static boolean isNumberType(int type) {
        return type == 2 || type == 3 || type == -6 || type == 5 || type == 4 || type == -5 || type == 8 || type == 6 || type == 7;
    }

    public static boolean isIntegerType(int type) {
        return type == -6 || type == 5 || type == 4 || type == -5;
    }

    public static boolean isIntervalType(int type) {
        switch (type) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                return true;
            }
        }
        return false;
    }

    public static boolean isLOBType(int type) {
        return type == -4 || type == -1 || type == -10;
    }

    public static boolean isTimeType(int type) {
        return type == 93 || type == 92;
    }

    public static int mapDataTypes(int sqlType) {
        if (TypeUtilities.isIntervalType(sqlType)) {
            return 1111;
        }
        if (-8 == sqlType) {
            return 1;
        }
        if (-9 == sqlType) {
            return 12;
        }
        if (-10 == sqlType) {
            return -1;
        }
        if (-11 == sqlType) {
            return 1111;
        }
        return sqlType;
    }

    public static int NormalizeDateTimeTypeForODBC2(int in_sqlType, boolean in_isODBC2) {
        if (in_isODBC2) {
            switch (in_sqlType) {
                case 91: {
                    return 9;
                }
                case 92: {
                    return 10;
                }
                case 93: {
                    return 11;
                }
            }
            return in_sqlType;
        }
        switch (in_sqlType) {
            case 9: {
                return 91;
            }
            case 10: {
                return 92;
            }
            case 11: {
                return 93;
            }
        }
        return in_sqlType;
    }

    public static Integer getTypeForSqlTypeString(String sqlTypeName) {
        if (null == sqlTypeName) {
            throw new NullPointerException();
        }
        String normalized = sqlTypeName.trim().toUpperCase();
        if (!s_stringToSQLTypeMap.containsKey(normalized)) {
            return null;
        }
        return s_stringToSQLTypeMap.get(normalized);
    }

    public static String sqlTypeToString(short sqlType) {
        switch (sqlType) {
            case 2003: {
                return "SQL_ARRAY";
            }
            case -5: {
                return "SQL_BIGINT";
            }
            case 3: {
                return "SQL_DECIMAL";
            }
            case 8: {
                return "SQL_DOUBLE";
            }
            case 6: {
                return "SQL_FLOAT";
            }
            case 4: {
                return "SQL_INTEGER";
            }
            case 2: {
                return "SQL_NUMERIC";
            }
            case 0: {
                return "NULL";
            }
            case 7: {
                return "SQL_REAL";
            }
            case 5: {
                return "SQL_SMALLINT";
            }
            case -2: {
                return "SQL_BINARY";
            }
            case -7: {
                return "SQL_BIT";
            }
            case 16: {
                return "SQL_BOOLEAN";
            }
            case 1: {
                return "SQL_CHAR";
            }
            case -4: {
                return "SQL_LONGVARBINARY";
            }
            case -1: {
                return "SQL_LONGVARCHAR";
            }
            case 91: {
                return "SQL_TYPE_DATE";
            }
            case 92: {
                return "SQL_TYPE_TIME";
            }
            case 93: {
                return "SQL_TYPE_TIMESTAMP";
            }
            case -6: {
                return "SQL_TINYINT";
            }
            case -3: {
                return "SQL_VARBINARY";
            }
            case 12: {
                return "SQL_VARCHAR";
            }
            case 2002: {
                return "SQL_STRUCT";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 1111: {
                return "SQL_OTHER";
            }
            case -11: {
                return "SQL_GUID";
            }
            case -8: {
                return "SQL_WCHAR";
            }
            case -9: {
                return "SQL_WVARCHAR";
            }
            case -10: {
                return "SQL_WLONGVARCHAR";
            }
            case 103: {
                return "SQL_INTERVAL_DAY";
            }
            case 108: {
                return "SQL_INTERVAL_DAY_TO_HOUR";
            }
            case 109: {
                return "SQL_INTERVAL_DAY_TO_MINUTE";
            }
            case 110: {
                return "SQL_INTERVAL_DAY_TO_SECOND";
            }
            case 104: {
                return "SQL_INTERVAL_HOUR";
            }
            case 111: {
                return "SQL_INTERVAL_HOUR_TO_MINUTE";
            }
            case 112: {
                return "SQL_INTERVAL_HOUR_TO_SECOND";
            }
            case 105: {
                return "SQL_INTERVAL_MINUTE";
            }
            case 113: {
                return "SQL_INTERVAL_MINUTE_TO_SECOND";
            }
            case 102: {
                return "SQL_INTERVAL_MONTH";
            }
            case 106: {
                return "SQL_INTERVAL_SECOND";
            }
            case 101: {
                return "SQL_INTERVAL_YEAR";
            }
            case 107: {
                return "SQL_INTERVAL_YEAR_TO_MONTH";
            }
        }
        return null;
    }

    public static int getNumPrecRadix(short sqlType) {
        if (TypeUtilities.isApproximateNumericType(sqlType)) {
            return 2;
        }
        if (TypeUtilities.isIntegerType(sqlType) || TypeUtilities.isExactNumericType(sqlType)) {
            return 10;
        }
        return 0;
    }

    public static boolean verifySQLTypeMapping(int sqlType, Class javaClass) {
        boolean isValid = true;
        switch (sqlType) {
            case 4: {
                isValid = javaClass == Integer.class || javaClass == Long.class;
                break;
            }
            case 2: 
            case 3: {
                isValid = javaClass == BigDecimal.class;
                break;
            }
            case -7: 
            case 16: {
                isValid = javaClass == Boolean.class;
                break;
            }
            case -6: {
                isValid = javaClass == Short.class || javaClass == Byte.class;
                break;
            }
            case 5: {
                isValid = javaClass == Integer.class || javaClass == Short.class;
                break;
            }
            case -5: {
                isValid = javaClass == BigInteger.class || javaClass == Long.class;
                break;
            }
            case 7: {
                isValid = javaClass == Float.class;
                break;
            }
            case 6: {
                isValid = javaClass == Double.class || javaClass == Float.class;
                break;
            }
            case 8: {
                isValid = javaClass == Double.class;
                break;
            }
            case 91: {
                isValid = javaClass == Date.class || javaClass == java.util.Date.class || javaClass == Calendar.class;
                break;
            }
            case 92: {
                isValid = javaClass == Time.class || javaClass == TimeTz.class || javaClass == java.util.Date.class || javaClass == Calendar.class;
                break;
            }
            case 93: {
                isValid = javaClass == TimestampTz.class || javaClass == Timestamp.class || javaClass == java.util.Date.class || javaClass == Time.class || javaClass == Date.class || javaClass == Calendar.class;
                break;
            }
            case -11: {
                isValid = javaClass == UUID.class;
                break;
            }
            case -10: 
            case -9: 
            case -8: {
                isValid = javaClass == String.class;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                isValid = javaClass == String.class || javaClass == java.util.Date.class || javaClass == Calendar.class || javaClass == BigInteger.class;
                break;
            }
            case -4: 
            case -3: {
                isValid = javaClass == byte[].class || javaClass == ByteArrayInputStream.class;
                break;
            }
            case 2002: {
                isValid = Struct.class.isAssignableFrom(javaClass);
                break;
            }
            case 2000: {
                isValid = true;
                break;
            }
            default: {
                isValid = false;
            }
        }
        return isValid;
    }

    public static TypeMetadata getNestedMetadata(IArray iarray) {
        TypeMetadata metadata = iarray.getBaseColumn().getTypeMetadata();
        while (metadata.getType() == 2003) {
            metadata = metadata.getNestedColumnList().get(0).getTypeMetadata();
        }
        return metadata;
    }

    public static int getDimensionofArray(IArray iarray) {
        int nesting = 0;
        TypeMetadata metadata = iarray.getBaseColumn().getTypeMetadata();
        while (metadata.getType() == 2003) {
            ++nesting;
            metadata = metadata.getNestedColumnList().get(0).getTypeMetadata();
        }
        return nesting;
    }
}

