/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import java.io.IOException;

public final class AuthHashResponseMessage
extends ResponseMessage {
    private byte[] m_salt = new byte[4];
    private boolean m_useMD5;
    private int m_userSaltLen;
    private byte[] m_userSalt = new byte[16];

    protected AuthHashResponseMessage(VStream vStream, boolean bl) {
        super(vStream);
        this.m_useMD5 = bl;
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        this.m_vStream.Receive(this.m_salt, 0, 4);
        if (n > 4) {
            this.m_userSaltLen = this.m_vStream.ReceiveIntegerR(4);
            if (this.m_userSaltLen != 16) {
                throw new IOException("Protocol Error. Received wrong user salt size: " + this.m_userSaltLen);
            }
            this.m_vStream.Receive(this.m_userSalt, 0, this.m_userSaltLen);
        }
    }

    public byte[] getSalt() {
        return this.m_salt;
    }

    public boolean useMD5() {
        return this.m_useMD5;
    }

    public byte[] getUserSalt() {
        return this.m_userSalt;
    }

    public int getUserSaltLength() {
        return this.m_userSaltLen;
    }

    @Override
    public MessageType getType() {
        return MessageType.AuthHash;
    }
}

