/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities;

import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.Searchable;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.Updatable;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.utilities.JDBCVersion;
import java.util.ArrayList;
import java.util.List;

public final class MetaDataFactory {
    private static int COLUMN_STRING_LENGTH = 128;
    private static int COLUMN_REMARKS_LENGTH = 254;
    private static int COLUMN_INTEGER_LENGTH = 10;
    private static int COLUMN_SMALLINT_LENGTH = 5;
    private static int NUM_COMMON_COLUMNS = 4;
    private static int NUM_COMMON_TABLE_COLUMNS = NUM_COMMON_COLUMNS - 1;
    private static int LENGTH_COMMON_TABLE_HEADER = 5;

    public static List<ColumnMetadata> createAttributeMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(21);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(3);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "TYPE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("ATTR_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("ATTR_TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("ATTR_SIZE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("ATTR_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_CATALOG", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_SCHEMA", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_TABLE", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SOURCE_DATA_TYPE", Nullable.NULLABLE);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createClientInfoPropertiesMetadata() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(4);
        try {
            ColumnMetadata nameMeta = MetaDataFactory.createStringMetaDataColumn("NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            nameMeta.setSearchable(Searchable.PREDICATE_NONE);
            nameMeta.setUpdatable(Updatable.READ_ONLY);
            columns.add(nameMeta);
            ColumnMetadata maxLengthMeta = MetaDataFactory.createIntegerMetaDataColumn("MAX_LEN", Nullable.NO_NULLS);
            maxLengthMeta.setSearchable(Searchable.PREDICATE_NONE);
            maxLengthMeta.setUpdatable(Updatable.READ_ONLY);
            columns.add(maxLengthMeta);
            ColumnMetadata defaultValueMeta = MetaDataFactory.createStringMetaDataColumn("DEFAULT_VALUE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            defaultValueMeta.setSearchable(Searchable.PREDICATE_NONE);
            defaultValueMeta.setUpdatable(Updatable.READ_ONLY);
            columns.add(defaultValueMeta);
            ColumnMetadata descMeta = MetaDataFactory.createStringMetaDataColumn("DESCRIPTION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            descMeta.setSearchable(Searchable.PREDICATE_NONE);
            descMeta.setUpdatable(Updatable.READ_ONLY);
            columns.add(descMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createCatalogOnlyMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(1);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_CAT", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createColumnPrivilegesMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(columns);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("GRANTOR", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("GRANTEE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("PRIVILEGE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_GRANTABLE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createColumnsMetaData(JDBCVersion jdbcVersion) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(24);
        MetaDataFactory.addCommonMetaData(columns);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_CATALOG", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_SCHEMA", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SCOPE_TABLE", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SOURCE_DATA_TYPE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_AUTOINCREMENT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            if (JDBCVersion.JDBC41 == jdbcVersion || JDBCVersion.JDBC42 == jdbcVersion) {
                colMeta = MetaDataFactory.createStringMetaDataColumn("IS_GENERATEDCOLUMN", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
                columns.add(colMeta);
            }
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createForeignKeysMetaData() {
        String name;
        ColumnMetadata colMeta;
        int i;
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(14);
        MetaDataFactory.addCommonMetaData(columns);
        for (i = 0; i < NUM_COMMON_COLUMNS; ++i) {
            colMeta = (ColumnMetadata)columns.get(i);
            name = colMeta.getName();
            name = "PK" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        MetaDataFactory.addCommonMetaData(columns);
        for (i = NUM_COMMON_COLUMNS; i < 2 * NUM_COMMON_COLUMNS; ++i) {
            colMeta = (ColumnMetadata)columns.get(i);
            name = colMeta.getName();
            name = "FK" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta2 = MetaDataFactory.createShortMetaDataColumn("KEY_SEQ", Nullable.NO_NULLS);
            columns.add(colMeta2);
            colMeta2 = MetaDataFactory.createShortMetaDataColumn("UPDATE_RULE", Nullable.NULLABLE);
            columns.add(colMeta2);
            colMeta2 = MetaDataFactory.createShortMetaDataColumn("DELETE_RULE", Nullable.NULLABLE);
            columns.add(colMeta2);
            colMeta2 = MetaDataFactory.createStringMetaDataColumn("FK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta2);
            colMeta2 = MetaDataFactory.createStringMetaDataColumn("PK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta2);
            colMeta2 = MetaDataFactory.createShortMetaDataColumn("DEFERRABILITY", Nullable.NO_NULLS);
            columns.add(colMeta2);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createFunctionsMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "FUNCTION" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("FUNCTION_TYPE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createFunctionColumnsMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(columns);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "FUNCTION" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createShortMetaDataColumn("COLUMN_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            colMeta.setName("PRECISION");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            colMeta.setName("LENGTH");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            colMeta.setName("SCALE");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            colMeta.setName("RADIX");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            colMeta.setName("CHAR_OCTET_LENGTH");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            colMeta.setName("ORDINAL_POSITION");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createIndexInfoMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(NUM_COMMON_TABLE_COLUMNS);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createBooleanMetaDataColumn("NON_UNIQUE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("INDEX_QUALIFIER", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("INDEX_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("ASC_OR_DESC", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CARDINALITY", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("PAGES", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("FILTER_CONDITION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createPrimaryKeysMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(6);
        MetaDataFactory.addCommonMetaData(columns);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createShortMetaDataColumn("KEY_SEQ", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("PK_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createProcedureColumnsMetaData(JDBCVersion jdbcVersion) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(columns);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "PROCEDURE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createShortMetaDataColumn("COLUMN_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            colMeta.setName("PRECISION");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            colMeta.setName("LENGTH");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            colMeta.setName("SCALE");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            colMeta.setName("RADIX");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_DEF", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("ORDINAL_POSITION", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createProceduresMetaData(JDBCVersion jdbcVersion) {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(8);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "PROCEDURE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_INPUT_PARAMS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_OUTPUT_PARAMS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_RESULT_SETS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("PROCEDURE_TYPE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SPECIFIC_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createPseudoColumnsMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(13);
        MetaDataFactory.addCommonMetaData(columns);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            colMeta.setName("PRECISION");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            colMeta.setName("SCALE");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            colMeta.setName("RADIX");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_USAGE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("CHAR_OCTET_LENGTH", Nullable.NULLABLE);
            colMeta.setName("CHAR_OCTET_LENGTH");
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_NULLABLE", Nullable.NO_NULLS, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createSchemasOnlyMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(2);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_SCHEM", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_CATALOG", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createSpecialColumnsMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(8);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createShortMetaDataColumn("SCOPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("COLUMN_SIZE", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("BUFFER_LENGTH", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("DECIMAL_DIGITS", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("PSEUDO_COLUMN", Nullable.NO_NULLS);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createSuperTablesMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(4);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(3);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("SUPERTABLE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createSuperTypesMetaData() {
        String name;
        ColumnMetadata colMeta;
        int i;
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(6);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(NUM_COMMON_TABLE_COLUMNS);
        for (i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            colMeta = (ColumnMetadata)columns.get(i);
            name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "TYPE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(6);
        for (i = NUM_COMMON_TABLE_COLUMNS; i < 2 * NUM_COMMON_TABLE_COLUMNS; ++i) {
            colMeta = (ColumnMetadata)columns.get(i);
            name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "SUPERTYPE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        return columns;
    }

    public static List<ColumnMetadata> createTablePrivilegesMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(7);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(3);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("GRANTOR", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("GRANTEE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("PRIVILEGE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("IS_GRANTABLE", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createTablesMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(10);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(3);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_TYPE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_CAT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_SCHEM", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("SELF_REFERENCING_COL_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REF_GENERATION", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createTableTypesMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(1);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_TYPE", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createTypeInfoMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(18);
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TYPE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("PRECISION", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("LITERAL_PREFIX", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("LITERAL_SUFFIX", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("CREATE_PARAMS", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("NULLABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createBooleanMetaDataColumn("CASE_SENSITIVE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("SEARCHABLE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createBooleanMetaDataColumn("UNSIGNED_ATTRIBUTE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createBooleanMetaDataColumn("FIXED_PREC_SCALE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createBooleanMetaDataColumn("AUTO_INCREMENT", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("LOCAL_TYPE_NAME", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("MINIMUM_SCALE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("MAXIMUM_SCALE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("SQL_DATETIME_SUB", Nullable.NULLABLE);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("NUM_PREC_RADIX", Nullable.NULLABLE);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    public static List<ColumnMetadata> createUDTMetaData() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(7);
        MetaDataFactory.addCommonMetaData(columns);
        columns.remove(NUM_COMMON_TABLE_COLUMNS);
        for (int i = 0; i < NUM_COMMON_TABLE_COLUMNS; ++i) {
            ColumnMetadata colMeta = (ColumnMetadata)columns.get(i);
            String name = colMeta.getName().substring(LENGTH_COMMON_TABLE_HEADER);
            name = "TYPE" + name;
            colMeta.setLabel(name);
            colMeta.setName(name);
        }
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("CLASS_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createIntegerMetaDataColumn("DATA_TYPE", Nullable.NO_NULLS);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("REMARKS", Nullable.NULLABLE, COLUMN_REMARKS_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createShortMetaDataColumn("BASE_TYPE", Nullable.NULLABLE);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
        return columns;
    }

    private static void addCommonMetaData(List<ColumnMetadata> columns) {
        try {
            ColumnMetadata colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_CAT", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_SCHEM", Nullable.NULLABLE, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("TABLE_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
            colMeta = MetaDataFactory.createStringMetaDataColumn("COLUMN_NAME", Nullable.NO_NULLS, COLUMN_STRING_LENGTH);
            columns.add(colMeta);
        }
        catch (NumericOverflowException numericOverflowException) {
            // empty catch block
        }
    }

    private static ColumnMetadata createBooleanMetaDataColumn(String name, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMeta;
        try {
            typeMeta = TypeMetadata.createTypeMetadata(-7);
        }
        catch (ErrorException e) {
            throw new RuntimeException(e);
        }
        typeMeta.setTypeName("BIT");
        typeMeta.setLocalTypeName("BIT");
        ColumnMetadata colMeta = new ColumnMetadata(typeMeta);
        colMeta.setLabel(name);
        colMeta.setName(name);
        colMeta.setNullable(nullable);
        colMeta.setSearchable(Searchable.PREDICATE_NONE);
        colMeta.setUpdatable(Updatable.READ_ONLY);
        colMeta.setColumnLength(COLUMN_SMALLINT_LENGTH);
        return colMeta;
    }

    private static ColumnMetadata createIntegerMetaDataColumn(String name, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMeta;
        try {
            typeMeta = TypeMetadata.createTypeMetadata(4);
        }
        catch (ErrorException e) {
            throw new RuntimeException(e);
        }
        typeMeta.setTypeName("INTEGER");
        typeMeta.setLocalTypeName("INTEGER");
        ColumnMetadata colMeta = new ColumnMetadata(typeMeta);
        colMeta.setLabel(name);
        colMeta.setName(name);
        colMeta.setNullable(nullable);
        colMeta.setSearchable(Searchable.PREDICATE_NONE);
        colMeta.setUpdatable(Updatable.READ_ONLY);
        colMeta.setColumnLength(COLUMN_INTEGER_LENGTH);
        return colMeta;
    }

    private static ColumnMetadata createShortMetaDataColumn(String name, Nullable nullable) throws NumericOverflowException {
        TypeMetadata typeMeta;
        try {
            typeMeta = TypeMetadata.createTypeMetadata(5);
        }
        catch (ErrorException e) {
            throw new RuntimeException(e);
        }
        typeMeta.setTypeName("SMALLINT");
        typeMeta.setLocalTypeName("SMALLINT");
        ColumnMetadata colMeta = new ColumnMetadata(typeMeta);
        colMeta.setLabel(name);
        colMeta.setName(name);
        colMeta.setNullable(nullable);
        colMeta.setSearchable(Searchable.PREDICATE_NONE);
        colMeta.setUpdatable(Updatable.READ_ONLY);
        colMeta.setColumnLength(COLUMN_SMALLINT_LENGTH);
        return colMeta;
    }

    private static ColumnMetadata createStringMetaDataColumn(String name, Nullable nullable, int length) throws NumericOverflowException {
        TypeMetadata typeMeta;
        try {
            typeMeta = TypeMetadata.createTypeMetadata(12);
        }
        catch (ErrorException e) {
            throw new RuntimeException(e);
        }
        typeMeta.setTypeName("VARCHAR");
        typeMeta.setLocalTypeName("VARCHAR");
        ColumnMetadata colMeta = new ColumnMetadata(typeMeta);
        colMeta.setLabel(name);
        colMeta.setName(name);
        colMeta.setNullable(nullable);
        colMeta.setSearchable(Searchable.PREDICATE_NONE);
        colMeta.setUpdatable(Updatable.READ_ONLY);
        colMeta.setColumnLength(length);
        return colMeta;
    }
}

