/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.element.condition;

import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.exception.WhenTimeoutException;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import java.util.concurrent.TimeoutException;

public class TimeoutCondition
extends WhenCondition {
    @Override
    public void executeCondition(Integer slotIndex) throws Exception {
        try {
            super.executeCondition(slotIndex);
        }
        catch (WhenTimeoutException ex) {
            String errMsg = StrFormatter.format((String)"Timed out when executing the chain [{}] because [{}] exceeded {} {}.", (Object[])new Object[]{this.getCurrChainId(), this.getCurrentExecutableId(), this.getMaxWaitTime(), this.getMaxWaitTimeUnit().toString().toLowerCase()});
            throw new TimeoutException(errMsg);
        }
    }

    private String getCurrentExecutableId() {
        Executable executable = this.getExecutableList().get(0);
        if (ObjectUtil.isNotNull((Object)executable.getId())) {
            return executable.getId();
        }
        switch (executable.getExecuteType()) {
            case CHAIN: {
                return ((Chain)executable).getChainId();
            }
            case CONDITION: {
                return "condition-" + ((Condition)executable).getConditionType().getName();
            }
            case NODE: {
                return "node-" + ((Node)executable).getType().getCode();
            }
        }
        return "unknown-executable";
    }
}

