/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.datasource.impl;

import com.yomahub.liteflow.parser.sql.datasource.LiteFlowDataSourceConnect;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import com.yomahub.liteflow.spi.holder.ContextAwareHolder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowAutoLookUpJdbcConn
implements LiteFlowDataSourceConnect {
    private static final Logger LOG = LoggerFactory.getLogger(LiteFlowAutoLookUpJdbcConn.class);

    @Override
    public boolean filter(SQLParserVO config) {
        return true;
    }

    @Override
    public Connection getConn(SQLParserVO config) throws Exception {
        return DataSourceBeanNameHolder.autoLookUpConn(config);
    }

    public static class DataSourceBeanNameHolder {
        private static String DATA_SOURCE_NAME = null;

        public static synchronized void init(String dataSourceName) {
            if (DATA_SOURCE_NAME == null) {
                DATA_SOURCE_NAME = dataSourceName;
            }
        }

        public static String getDataSourceName() {
            return DATA_SOURCE_NAME;
        }

        public static boolean isNotInit() {
            return DATA_SOURCE_NAME == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public static Connection autoLookUpConn(SQLParserVO sqlParserVO) throws SQLException {
            Map dataSourceMap = ContextAwareHolder.loadContextAware().getBeansOfType(DataSource.class);
            if (LiteFlowJdbcUtil.DataSourceBeanNameHolder.isNotInit()) {
                Class<LiteFlowJdbcUtil.DataSourceBeanNameHolder> clazz = LiteFlowJdbcUtil.DataSourceBeanNameHolder.class;
                // MONITORENTER : com.yomahub.liteflow.parser.sql.util.LiteFlowJdbcUtil$DataSourceBeanNameHolder.class
                if (LiteFlowJdbcUtil.DataSourceBeanNameHolder.isNotInit()) {
                    String executeSql = LiteFlowJdbcUtil.buildCheckSql(sqlParserVO);
                    for (Map.Entry entry : dataSourceMap.entrySet()) {
                        String dataSourceName = (String)entry.getKey();
                        DataSource dataSource = (DataSource)entry.getValue();
                        if (LiteFlowJdbcUtil.checkConnectionCanExecuteSql(dataSource.getConnection(), executeSql)) {
                            LiteFlowJdbcUtil.DataSourceBeanNameHolder.init(dataSourceName);
                            if (!sqlParserVO.getSqlLogEnabled().booleanValue()) break;
                            LOG.info("use dataSourceName[{}],has found liteflow config", (Object)dataSourceName);
                            break;
                        }
                        LOG.info("check dataSourceName[{}],but not has liteflow config", (Object)dataSourceName);
                    }
                }
                // MONITOREXIT : clazz
            }
            DataSource dataSource = Optional.ofNullable(LiteFlowJdbcUtil.DataSourceBeanNameHolder.getDataSourceName()).map(dataSourceMap::get).orElse(null);
            if (dataSource == null) {
                throw new ELSQLException("can not found liteflow config in dataSourceName " + dataSourceMap.keySet());
            }
            Connection connection = dataSource.getConnection();
            if (connection != null) return connection;
            throw new ELSQLException("can not found liteflow config in dataSourceName " + dataSourceMap.keySet());
        }
    }
}

