/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc;

import io.github.iamazy.elasticsearch.dsl.jdbc.AbstractDriverBasedDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DriverManagerDataSource
extends AbstractDriverBasedDataSource {
    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String url) {
        this.setUrl(url);
    }

    public DriverManagerDataSource(String url, Properties properties) {
        this.setUrl(url);
        this.setProperties(properties);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable cause) {
            cause.printStackTrace();
        }
        if (classLoader == null && (classLoader = DriverManagerDataSource.class.getClassLoader()) == null) {
            try {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
        }
        return classLoader;
    }

    public void setDriverClassName(String driverClassName) {
        String driverClass = driverClassName.trim();
        try {
            Class.forName(driverClass, true, DriverManagerDataSource.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load JDBC driver class [" + driverClass + "]", e);
        }
    }

    @Override
    protected Connection getConnectionFromDriver(Properties props) throws SQLException {
        return this.getConnectionFromDriverManager(this.getUrl(), props);
    }

    protected Connection getConnectionFromDriverManager(String url, Properties properties) throws SQLException {
        return DriverManager.getConnection(url, properties);
    }
}

