/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc;

import io.github.iamazy.elasticsearch.dsl.jdbc.AbstractConnection;
import io.github.iamazy.elasticsearch.dsl.jdbc.ElasticDatabaseMetaData;
import io.github.iamazy.elasticsearch.dsl.jdbc.statement.ElasticPreparedStatement;
import io.github.iamazy.elasticsearch.dsl.jdbc.statement.ElasticStatement;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticConnection
extends AbstractConnection {
    private RestHighLevelClient client;
    private List<String> databases;

    ElasticConnection(String url, Properties properties, RestHighLevelClient client) {
        super(url, properties);
        this.client = client;
        String[] items = url.split("/");
        String database = items[items.length - 1];
        if (database.contains("?")) {
            database = database.split("[?]")[0];
        }
        this.databases = Arrays.asList(database.split("[,]"));
    }

    public RestHighLevelClient getRestClient() {
        return this.client;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ElasticStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ElasticPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ElasticPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ElasticDatabaseMetaData(this.url, this.properties.getOrDefault((Object)"user", "").toString());
    }

    public List<String> getDatabaseNames() {
        return this.databases;
    }

    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
            this.closed = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

