/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc;

import io.github.iamazy.elasticsearch.dsl.jdbc.ConnectionProxy;
import io.github.iamazy.elasticsearch.dsl.jdbc.DriverManagerDataSource;
import io.github.iamazy.elasticsearch.dsl.jdbc.ElasticConnection;
import io.github.iamazy.elasticsearch.dsl.jdbc.ElasticDataSource;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.ElasticClientProvider;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticConnectionDataSource
extends DriverManagerDataSource
implements ElasticDataSource {
    private final Object connectionMonitor = new Object();
    private boolean suppressClose;
    private Connection target;
    private Connection connection;
    private RestHighLevelClient restHighLevelClient;
    private ElasticClientProvider elasticClientProvider;

    public ElasticConnectionDataSource() {
    }

    public ElasticConnectionDataSource(String url, boolean suppressClose) {
        super(url);
        this.suppressClose = suppressClose;
    }

    public void setElasticClientProvider(ElasticClientProvider elasticClientProvider) {
        this.elasticClientProvider = elasticClientProvider;
    }

    public boolean isSuppressClose() {
        return this.suppressClose;
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.initConnection(username, password);
            }
            if (this.connection.isClosed()) {
                throw new SQLException("Connection was closed in ElasticSingleConnectionDataSource. Check that user code checks shouldClose() before closing Connections, or set 'suppressClose' to 'true'");
            }
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldClose(Connection connection) {
        Object object = this.connectionMonitor;
        synchronized (object) {
            return connection != this.connection && connection != this.target;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initConnection(String username, String password) throws SQLException {
        if (this.getUrl() == null) {
            throw new IllegalStateException("'url' property is required for lazily initializing a Connection");
        }
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
        }
        try {
            if (this.elasticClientProvider != null) {
                this.restHighLevelClient = this.elasticClientProvider.fromUrl(this.getUrl(), username, password);
                if (this.restHighLevelClient == null) {
                    throw new SQLException(String.format("Failed to build elastic client for url[%s]", this.getUrl()));
                }
                this.target = new ElasticConnection(this.getUrl(), null, this.restHighLevelClient);
            } else {
                this.target = this.getConnectionFromDriver();
            }
        }
        catch (Exception e) {
            throw new SQLException(String.format("Failed to create connection for url[%s]", this.getUrl()), e);
        }
        this.prepareConnection(this.target);
        this.connection = this.isSuppressClose() ? this.getCloseSuppressingConnectionProxy(this.target) : this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.closeConnection();
            this.target = null;
            this.connection = null;
        }
    }

    protected void prepareConnection(Connection connection) throws SQLException {
        Boolean autoCommit = this.getAutoCommitValue();
        if (autoCommit != null && connection.getAutoCommit() != autoCommit.booleanValue()) {
            connection.setAutoCommit(autoCommit);
        }
    }

    private void closeConnection() {
        if (this.target != null) {
            try {
                this.target.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.restHighLevelClient != null) {
            try {
                this.restHighLevelClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    protected Boolean getAutoCommitValue() {
        return Boolean.FALSE;
    }

    public void setAutoCommit(boolean autoCommit) {
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "unwrap": {
                    if (((Class)args[0]).isInstance(proxy)) {
                        return proxy;
                    }
                }
                case "isWrapperFor": {
                    if (((Class)args[0]).isInstance(proxy)) {
                        return true;
                    }
                }
                case "close": {
                    return null;
                }
                case "isClosed": {
                    return false;
                }
                case "getTargetConnection": {
                    return this.target;
                }
            }
            return method.invoke((Object)this.target, args);
        }
    }
}

