/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc;

import io.github.iamazy.elasticsearch.dsl.jdbc.ElasticConnection;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.ElasticClientManager;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.ElasticClientProvider;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticDriver
implements Driver {
    private RestHighLevelClient restHighLevelClient;
    private ElasticClientProvider elasticClientProvider;

    private ElasticDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Class<ElasticDriver> clazz = ElasticDriver.class;
        synchronized (ElasticDriver.class) {
            if (this.restHighLevelClient != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new ElasticConnection(url, info, this.restHighLevelClient);
            }
            if (this.elasticClientProvider == null) {
                this.elasticClientProvider = new ElasticClientManager();
            }
            String username = info.getOrDefault((Object)"user", "").toString();
            String password = info.getOrDefault((Object)"password", "").toString();
            this.restHighLevelClient = this.elasticClientProvider.fromUrl(url, username, password);
            if (this.restHighLevelClient == null) {
                throw new SQLException(String.format("Failed to create elastic client for url[%s]", url));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new ElasticConnection(url, info, this.restHighLevelClient);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"jdbc:es:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new UnsupportedOperationException("getParentLogger");
    }

    static {
        try {
            DriverManager.registerDriver(new ElasticDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

