/*
 * Decompiled with CFR 0.152.
 */
package io.github.iamazy.elasticsearch.dsl.jdbc.elastic;

import com.google.common.collect.Maps;
import io.github.iamazy.elasticsearch.dsl.jdbc.ClusterMode;
import io.github.iamazy.elasticsearch.dsl.jdbc.cons.JdbcConstants;
import io.github.iamazy.elasticsearch.dsl.jdbc.elastic.ElasticClientProvider;
import io.github.iamazy.elasticsearch.dsl.jdbc.exception.InvalidUrlException;
import io.github.iamazy.elasticsearch.dsl.jdbc.ssl.SslContextManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.SniffOnFailureListener;
import org.elasticsearch.client.sniff.Sniffer;

public class ElasticClientManager
implements ElasticClientProvider {
    private final Map<String, RestHighLevelClient> clientProxyMap = Maps.newHashMap();

    @Override
    public RestHighLevelClient fromUrl(String url, String username, String password) {
        if (this.clientProxyMap.containsKey(url)) {
            return this.clientProxyMap.get(url);
        }
        Map<String, Object> params = this.parseUrlParams(url);
        boolean useSsl = Boolean.parseBoolean(params.getOrDefault("useSSL", false).toString());
        String mode = params.getOrDefault("mode", "single").toString();
        Matcher matcher = JdbcConstants.IP_PORT_PATTERN.matcher(url);
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(0);
        while (matcher.find()) {
            String ip = matcher.group(1) == null ? "localhost" : matcher.group(1);
            int port = matcher.group(2) == null ? 9200 : Integer.parseInt(matcher.group(2));
            httpHosts.add(new HttpHost(ip, port, useSsl ? "https" : "http"));
        }
        String token = username + ":" + password;
        this.clientProxyMap.put(url, this.initClient(httpHosts, useSsl, this.parseClusterMode(mode), token));
        return this.clientProxyMap.get(url);
    }

    private RestHighLevelClient initClient(List<HttpHost> httpHosts, boolean useSsl, ClusterMode mode, String token) {
        RestHighLevelClient restHighLevelClient;
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts.toArray(new HttpHost[0])).setNodeSelector(NodeSelector.SKIP_DEDICATED_MASTERS).setRequestConfigCallback(builder -> builder.setConnectTimeout(50000).setSocketTimeout(600000));
        if (useSsl) {
            restClientBuilder.setHttpClientConfigCallback(httpAsyncClientBuilder -> {
                SSLContext sslContext;
                httpAsyncClientBuilder.setSSLHostnameVerifier((s, sslSession) -> true);
                try {
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, SslContextManager.TRUST_ALL_CERTS, new SecureRandom());
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new RuntimeException(e.getMessage());
                }
                httpAsyncClientBuilder.setSSLContext(sslContext);
                String basicToken = Base64.getEncoder().encodeToString(token.getBytes());
                httpAsyncClientBuilder.setDefaultHeaders(Collections.singletonList(new BasicHeader("Authorization", "Basic " + basicToken)));
                return httpAsyncClientBuilder;
            });
        }
        if (ClusterMode.CLUSTER.equals((Object)mode)) {
            SniffOnFailureListener sniffOnFailureListener = new SniffOnFailureListener();
            restClientBuilder.setFailureListener((RestClient.FailureListener)sniffOnFailureListener);
            restHighLevelClient = new RestHighLevelClient(restClientBuilder);
            ElasticsearchNodesSniffer nodesSniffer = new ElasticsearchNodesSniffer(restHighLevelClient.getLowLevelClient(), ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, useSsl ? ElasticsearchNodesSniffer.Scheme.HTTPS : ElasticsearchNodesSniffer.Scheme.HTTP);
            Sniffer sniffer = Sniffer.builder((RestClient)restHighLevelClient.getLowLevelClient()).setSniffIntervalMillis(5000).setNodesSniffer((NodesSniffer)nodesSniffer).build();
            sniffOnFailureListener.setSniffer(sniffer);
        } else {
            restHighLevelClient = new RestHighLevelClient(restClientBuilder);
        }
        return restHighLevelClient;
    }

    private ClusterMode parseClusterMode(String mode) {
        switch (mode) {
            case "cluster": {
                return ClusterMode.CLUSTER;
            }
            case "cross_cluster": {
                return ClusterMode.CROSS_CLUSTER;
            }
        }
        return ClusterMode.SINGLE;
    }

    public static RequestOptions requestOptions(String token) {
        HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory responseConsumerFactory = new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(Integer.MAX_VALUE);
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)responseConsumerFactory);
        builder.addHeader("Authorization", "Basic " + token);
        return builder.build();
    }

    private Map<String, Object> parseUrlParams(String url) {
        if (!StringUtils.startsWithIgnoreCase((CharSequence)url, (CharSequence)"jdbc:es:")) {
            throw new InvalidUrlException("[" + url + "] is an invalid elasticsearch jdbc url");
        }
        if (url.contains("?")) {
            HashMap<String, Object> params = new HashMap<String, Object>(0);
            try {
                String[] items;
                for (String item : items = url.substring(url.indexOf(63) + 1).split("[&]")) {
                    String[] split = item.split("[=]");
                    params.put(split[0], split[1]);
                }
            }
            catch (Exception e) {
                throw new InvalidUrlException(e.getMessage());
            }
            return params;
        }
        return Collections.emptyMap();
    }
}

